/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.tasker.task;

import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.task.TaskState;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import java.util.List;
import java.util.function.Consumer;

public abstract class AbstractTaskerTask
implements TaskerTask {
    private final Integer id;
    private final Object taskObject;
    private final List<Consumer<TaskerTask>> taskEndHandlers;
    private TaskState state = TaskState.SCHEDULED;

    public static AbstractTaskerTask of(Integer id, Object taskObject, List<Consumer<TaskerTask>> taskEndHandlers) {
        AbstractTaskerTask task = new AbstractTaskerTask(id, taskObject, (List)taskEndHandlers){};
        Tasker.register(task);
        return task;
    }

    @Override
    public TaskState getState() {
        if (this.state == TaskState.SCHEDULED) {
            return this.state;
        }
        if (this.state == TaskState.CANCELLED) {
            return this.state;
        }
        this.state = Tasker.getState(this);
        return this.state;
    }

    @Override
    public void cancel() {
        Tasker.cancel(this);
    }

    public AbstractTaskerTask(Integer id, Object taskObject, List<Consumer<TaskerTask>> taskEndHandlers) {
        this.id = id;
        this.taskObject = taskObject;
        this.taskEndHandlers = taskEndHandlers;
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    public Object getTaskObject() {
        return this.taskObject;
    }

    public List<Consumer<TaskerTask>> getTaskEndHandlers() {
        return this.taskEndHandlers;
    }
}

