/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.ComponentLike;
import io.github.pronze.lib.kyori.adventure.text.TextComponent;
import io.github.pronze.lib.kyori.adventure.text.format.NamedTextColor;
import io.github.pronze.lib.kyori.adventure.text.format.TextColor;
import io.github.pronze.lib.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.github.pronze.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AdventureHelper {
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER;
    private static final GsonComponentSerializer GSON_COMPONENT_SERIALIZER;
    public static final Map<NamedTextColor, Integer> NAMED_TEXT_COLOR_ID_MAP;

    @NotNull
    public static String toJson(@NotNull Component component) {
        return (String)GSON_COMPONENT_SERIALIZER.serialize(component);
    }

    @NotNull
    public static String toJson(@NotNull ComponentLike component) {
        return (String)GSON_COMPONENT_SERIALIZER.serialize(component.asComponent());
    }

    @NotNull
    public static String toLegacy(@NotNull Component component) {
        return LEGACY_COMPONENT_SERIALIZER.serialize(component);
    }

    @NotNull
    public static String toLegacy(@NotNull ComponentLike component) {
        return LEGACY_COMPONENT_SERIALIZER.serialize(component.asComponent());
    }

    @NotNull
    public static String toLegacyNullable(@Nullable Component component) {
        return component == null ? "" : LEGACY_COMPONENT_SERIALIZER.serialize(component);
    }

    @NotNull
    public static String toLegacyNullable(@Nullable ComponentLike component) {
        return component == null ? "" : LEGACY_COMPONENT_SERIALIZER.serialize(component.asComponent());
    }

    @Nullable
    public static String toLegacyNullableResult(@Nullable Component component) {
        return component == null ? null : LEGACY_COMPONENT_SERIALIZER.serialize(component);
    }

    @Nullable
    public static String toLegacyNullableResult(@Nullable ComponentLike component) {
        return component == null ? null : LEGACY_COMPONENT_SERIALIZER.serialize(component.asComponent());
    }

    @NotNull
    public static TextComponent toComponent(@NotNull String input) {
        return LEGACY_COMPONENT_SERIALIZER.deserialize(input);
    }

    @NotNull
    public static TextComponent toComponentNullable(@Nullable String input) {
        return input == null ? Component.empty() : LEGACY_COMPONENT_SERIALIZER.deserialize(input);
    }

    @Nullable
    public static TextComponent toComponentNullableResult(@Nullable String input) {
        return input == null ? null : LEGACY_COMPONENT_SERIALIZER.deserialize(input);
    }

    @NotNull
    public static String translateAlternateColorCodes(char altColorChar, @NotNull String textToTranslate) {
        char[] b = textToTranslate.toCharArray();
        for (int i = 0; i < b.length - 1; ++i) {
            if (b[i] != altColorChar || "0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(b[i + 1]) <= -1) continue;
            b[i] = 167;
            b[i + 1] = Character.toLowerCase(b[i + 1]);
        }
        return new String(b);
    }

    public static String toLegacyColorCode(TextColor color) {
        return "\u00a7" + Integer.toString(NAMED_TEXT_COLOR_ID_MAP.get(NamedTextColor.nearestTo(color)), 16);
    }

    private AdventureHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static LegacyComponentSerializer getLEGACY_COMPONENT_SERIALIZER() {
        return LEGACY_COMPONENT_SERIALIZER;
    }

    public static GsonComponentSerializer getGSON_COMPONENT_SERIALIZER() {
        return GSON_COMPONENT_SERIALIZER;
    }

    static {
        NAMED_TEXT_COLOR_ID_MAP = Map.ofEntries(Map.entry(NamedTextColor.BLACK, 0), Map.entry(NamedTextColor.DARK_BLUE, 1), Map.entry(NamedTextColor.DARK_GREEN, 2), Map.entry(NamedTextColor.DARK_AQUA, 3), Map.entry(NamedTextColor.DARK_RED, 4), Map.entry(NamedTextColor.DARK_PURPLE, 5), Map.entry(NamedTextColor.GOLD, 6), Map.entry(NamedTextColor.GRAY, 7), Map.entry(NamedTextColor.DARK_GRAY, 8), Map.entry(NamedTextColor.BLUE, 9), Map.entry(NamedTextColor.GREEN, 10), Map.entry(NamedTextColor.AQUA, 11), Map.entry(NamedTextColor.RED, 12), Map.entry(NamedTextColor.LIGHT_PURPLE, 13), Map.entry(NamedTextColor.YELLOW, 14), Map.entry(NamedTextColor.WHITE, 15));
        LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().hexColors().useUnusualXRepeatedCharacterHexFormat().character('\u00a7').build();
        GSON_COMPONENT_SERIALIZER = GsonComponentSerializer.gson();
    }
}

