/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import io.github.pronze.lib.screaminglib.utils.Wrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BidirectionalConverter<SpecificWrapper extends Wrapper> {
    private final Map<Class<?>, Function<Object, SpecificWrapper>> p2wConverters = new HashMap();
    private final Map<Class<?>, Function<SpecificWrapper, Object>> w2pConverters = new HashMap();
    private Class<?> normalizeType;

    @NotNull
    public <P> BidirectionalConverter<SpecificWrapper> registerW2P(@NotNull Class<P> type, @NotNull Function<SpecificWrapper, P> convertor) {
        this.w2pConverters.put(type, convertor);
        return this;
    }

    @NotNull
    public <P> BidirectionalConverter<SpecificWrapper> normalizeType(Class<P> type) {
        this.normalizeType = type;
        return this;
    }

    @NotNull
    public <P> BidirectionalConverter<SpecificWrapper> registerP2W(@NotNull Class<P> type, @NotNull Function<P, SpecificWrapper> convertor) {
        this.p2wConverters.put(type, convertor);
        return this;
    }

    @NotNull
    public <P> SpecificWrapper convert(@NotNull P object) {
        return (SpecificWrapper)((Wrapper)this.convertOptional(object).orElseThrow(() -> new UnsupportedOperationException("Can't convert " + object.getClass().getName() + " to the wrapper")));
    }

    @NotNull
    public <P> Optional<SpecificWrapper> convertOptional(@Nullable P object) {
        if (object == null) {
            return Optional.empty();
        }
        return this.p2wConverters.entrySet().stream().filter(c -> ((Class)c.getKey()).isInstance(object)).map(entry -> (Wrapper)((Function)entry.getValue()).apply(object)).filter(Objects::nonNull).findFirst();
    }

    @NotNull
    public <P> P convert(@NotNull SpecificWrapper object, @NotNull Class<P> newType) {
        return this.convertOptional(object, newType).orElseThrow(() -> new UnsupportedOperationException("Can't convert wrapper " + object.getClass().getName() + " to " + newType.getName()));
    }

    @NotNull
    public <P> Optional<P> convertOptional(@Nullable SpecificWrapper object, @NotNull Class<P> newType) {
        if (object == null) {
            return Optional.empty();
        }
        if (newType.isInstance(object)) {
            return Optional.of(object);
        }
        return this.w2pConverters.entrySet().stream().filter(c -> newType.isAssignableFrom((Class)c.getKey())).map(entry -> ((Function)entry.getValue()).apply(object)).filter(Objects::nonNull).findFirst();
    }

    @NotNull
    public SpecificWrapper normalize(@NotNull SpecificWrapper object) {
        if (this.normalizeType == null) {
            throw new UnsupportedOperationException("Can't normalize " + object.getClass().getName() + ", no normalization class is registered");
        }
        return this.convert(this.convert(object, this.normalizeType));
    }

    private BidirectionalConverter() {
    }

    public static <SpecificWrapper extends Wrapper> BidirectionalConverter<SpecificWrapper> build() {
        return new BidirectionalConverter<SpecificWrapper>();
    }
}

