/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CollectionLinkedToCollection<L, O>
implements Collection<L> {
    protected final Collection<O> original;
    protected final Function<L, O> linkToOriginal;
    protected final Function<O, L> originalToLink;

    @Override
    public int size() {
        return this.original.size();
    }

    @Override
    public boolean isEmpty() {
        return this.original.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.original.contains(this.linkToOriginal.apply(o));
    }

    @Override
    @NotNull
    public Iterator<L> iterator() {
        final Iterator<O> realIterator = this.original.iterator();
        return new Iterator<L>(){

            @Override
            public boolean hasNext() {
                return realIterator.hasNext();
            }

            @Override
            public L next() {
                return CollectionLinkedToCollection.this.originalToLink.apply(realIterator.next());
            }

            @Override
            public void remove() {
                realIterator.remove();
            }
        };
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.original.stream().map(this.originalToLink).toArray();
    }

    @Override
    @NotNull
    public <T> @NotNull T @NotNull [] toArray(@NotNull T[] a) {
        return this.original.stream().map(this.originalToLink).toArray((int value) -> (Object[])Array.newInstance(a.getClass().getComponentType(), value));
    }

    @Override
    public boolean add(L e) {
        O a = this.linkToOriginal.apply(e);
        if (a != null) {
            return this.original.add(a);
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        O a = this.linkToOriginal.apply(o);
        if (a != null) {
            return this.original.remove(a);
        }
        return false;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.original.containsAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends L> c) {
        return this.original.addAll(c.stream().map(this.linkToOriginal).collect(Collectors.toList()));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.original.removeAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.original.retainAll(c.stream().map(o -> this.linkToOriginal.apply(o)).collect(Collectors.toList()));
    }

    @Override
    public void clear() {
        this.original.clear();
    }

    public CollectionLinkedToCollection(Collection<O> original, Function<L, O> linkToOriginal, Function<O, L> originalToLink) {
        this.original = original;
        this.linkToOriginal = linkToOriginal;
        this.originalToLink = originalToLink;
    }
}

