/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

import io.github.pronze.lib.screaminglib.utils.Controllable;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ControllableImpl
implements Controllable {
    private final List<ControllableImpl> controllableList = new LinkedList<ControllableImpl>();
    private Runnable enableMethod;
    private Runnable postEnableMethod;
    private Runnable preDisableMethod;
    private Runnable disableMethod;

    @Override
    public Controllable enable(@NotNull Runnable enableMethod) {
        this.enableMethod = enableMethod;
        return this;
    }

    @Override
    public Controllable postEnable(@NotNull Runnable postEnableMethod) {
        this.postEnableMethod = postEnableMethod;
        return this;
    }

    @Override
    public Controllable preDisable(@NotNull Runnable preDisableMethod) {
        this.preDisableMethod = preDisableMethod;
        return this;
    }

    @Override
    public Controllable disable(@NotNull Runnable disableMethod) {
        this.disableMethod = disableMethod;
        return this;
    }

    @Override
    public Controllable child() {
        ControllableImpl controllable = new ControllableImpl();
        this.controllableList.add(controllable);
        return controllable;
    }

    public void enable() {
        this.controllableList.forEach(ControllableImpl::enable);
        if (this.enableMethod != null) {
            this.enableMethod.run();
        }
    }

    public void postEnable() {
        this.controllableList.forEach(ControllableImpl::postEnable);
        if (this.postEnableMethod != null) {
            this.postEnableMethod.run();
        }
    }

    public void preDisable() {
        if (this.preDisableMethod != null) {
            this.preDisableMethod.run();
        }
        new LinkedList<ControllableImpl>(this.controllableList).descendingIterator().forEachRemaining(ControllableImpl::preDisable);
    }

    public void disable() {
        if (this.disableMethod != null) {
            this.disableMethod.run();
        }
        new LinkedList<ControllableImpl>(this.controllableList).descendingIterator().forEachRemaining(ControllableImpl::disable);
    }

    public void reload() {
        this.preDisable();
        this.disable();
        this.enable();
        this.postEnable();
    }
}

