/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils;

public class Triple<F, S, T> {
    private final F first;
    private final S second;
    private final T third;

    public static <F, S, T> Triple<F, S, T> of(F first, S second, T third) {
        return new Triple<F, S, T>(first, second, third);
    }

    public static <F, S, T> Triple<F, S, T> empty() {
        return new Triple<Object, Object, Object>(null, null, null);
    }

    public boolean areAllPresent() {
        return this.first != null && this.second != null && this.third != null;
    }

    public boolean isPresent() {
        return this.first != null || this.second != null || this.third != null;
    }

    public boolean isEmpty() {
        return this.first == null && this.second == null && this.third == null;
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public T third() {
        return this.third;
    }

    protected Triple(F first, S second, T third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public T getThird() {
        return this.third;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple other = (Triple)o;
        if (!other.canEqual(this)) {
            return false;
        }
        F this$first = this.getFirst();
        F other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        S this$second = this.getSecond();
        S other$second = other.getSecond();
        if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
            return false;
        }
        T this$third = this.getThird();
        T other$third = other.getThird();
        return !(this$third == null ? other$third != null : !this$third.equals(other$third));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Triple;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        F $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        S $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        T $third = this.getThird();
        result = result * 59 + ($third == null ? 43 : $third.hashCode());
        return result;
    }

    public String toString() {
        return "Triple(first=" + this.getFirst() + ", second=" + this.getSecond() + ", third=" + this.getThird() + ")";
    }
}

