/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import io.github.pronze.lib.screaminglib.utils.reflect.ClassMethod;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;

public final class ComponentUtils {
    public static final Class<?> NATIVE_COMPONENT_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "Component"));
    public static final Class<?> NATIVE_GSON_COMPONENT_SERIALIZER_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "text", "serializer", "gson", "GsonComponentSerializer"));
    public static final ClassMethod NATIVE_GSON_COMPONENT_SERIALIZER_GETTER = Reflect.getMethod(NATIVE_GSON_COMPONENT_SERIALIZER_CLASS, "gson", new Class[0]);

    public static Object componentToPlatform(Component component) {
        if (component == null) {
            return null;
        }
        if (NATIVE_COMPONENT_CLASS.isInstance(component)) {
            return component;
        }
        return ComponentUtils.componentToPlatform(component, NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]));
    }

    public static Object componentToPlatform(Component component, Object nativeGsonSerializer) {
        if (component == null) {
            return null;
        }
        String result = (String)GsonComponentSerializer.gson().serialize(component);
        return Reflect.getMethod(nativeGsonSerializer, "deserialize", String.class).invoke(result);
    }

    public static Component componentFromPlatform(Object platformComponent) {
        if (platformComponent == null) {
            return null;
        }
        if (platformComponent instanceof Component) {
            return (Component)platformComponent;
        }
        return ComponentUtils.componentFromPlatform(platformComponent, NATIVE_GSON_COMPONENT_SERIALIZER_GETTER.invokeStatic(new Object[0]), NATIVE_COMPONENT_CLASS);
    }

    public static Component componentFromPlatform(Object platformComponent, Object nativeGsonSerializer, Class<?> nativeComponentClass) {
        if (platformComponent == null) {
            return null;
        }
        String result = Reflect.getMethod(nativeGsonSerializer, "serialize", nativeComponentClass).invokeResulted(platformComponent).as(String.class);
        return GsonComponentSerializer.gson().deserialize(result);
    }

    private ComponentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

