/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure;

import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;

public final class KeyUtils {
    public static final Class<?> NATIVE_KEY_CLASS = Reflect.getClassSafe(String.join((CharSequence)".", "net", "kyori", "adventure", "key", "Key"));

    public static Object keyToPlatform(Key key) {
        if (NATIVE_KEY_CLASS.isInstance(key)) {
            return key;
        }
        return KeyUtils.keyToPlatform(key, NATIVE_KEY_CLASS);
    }

    public static Object keyToPlatform(Key key, Class<?> keyClass) {
        return Reflect.getMethod(keyClass, "key", String.class, String.class).invokeStatic(key.namespace(), key.value());
    }

    public static Key keyFromPlatform(Object platformObject) {
        if (platformObject instanceof Key) {
            return (Key)platformObject;
        }
        return Key.key(Reflect.fastInvokeResulted(platformObject, "namespace").as(String.class), Reflect.fastInvokeResulted(platformObject, "value").as(String.class));
    }

    private KeyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

