/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.inventory.Book;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.BookUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BookWrapper
implements Wrapper {
    private final Book book;

    @NotNull
    public Book asBook() {
        return this.book;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type.isInstance(this.book)) {
            return (T)this.book;
        }
        List<String> generalPackageSplit = Arrays.asList(type.getPackageName().split("\\."));
        generalPackageSplit.remove(generalPackageSplit.size() - 1);
        String generalPackage = String.join((CharSequence)".", generalPackageSplit);
        Class component = Reflect.getClassSafe(generalPackage + ".text.Component");
        Class gsonSerializer = Reflect.getClassSafe(generalPackage + ".text.serializer.gson.GsonComponentSerializer");
        if (component == null || gsonSerializer == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure needs to have gson serializer!");
        }
        return (T)BookUtils.bookToPlatform(this.book, type, component, Reflect.fastInvoke(gsonSerializer, "gson"));
    }

    public BookWrapper(Book book) {
        this.book = book;
    }

    public Book getBook() {
        return this.book;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookWrapper)) {
            return false;
        }
        BookWrapper other = (BookWrapper)o;
        Book this$book = this.getBook();
        Book other$book = other.getBook();
        return !(this$book == null ? other$book != null : !this$book.equals(other$book));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Book $book = this.getBook();
        result = result * 59 + ($book == null ? 43 : $book.hashCode());
        return result;
    }

    public String toString() {
        return "BookWrapper(book=" + this.getBook() + ")";
    }
}

