/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.bossbar.BossBar;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.BossBarUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class BossBarWrapper
implements Wrapper {
    private final BossBar bossBar;

    @NotNull
    public BossBar asBossBar() {
        return this.bossBar;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type.isInstance(this.bossBar)) {
            return (T)this.bossBar;
        }
        List<String> generalPackageSplit = Arrays.asList(type.getPackageName().split("\\."));
        generalPackageSplit.remove(generalPackageSplit.size() - 1);
        String generalPackage = String.join((CharSequence)".", generalPackageSplit);
        Class component = Reflect.getClassSafe(generalPackage + ".text.Component");
        Class gsonSerializer = Reflect.getClassSafe(generalPackage + ".text.serializer.gson.GsonComponentSerializer");
        Class color = Reflect.getClassSafe(type.getName() + "$Color");
        Class overlay = Reflect.getClassSafe(type.getName() + "$Overlay");
        Class flag = Reflect.getClassSafe(type.getName() + "$Flag");
        if (component == null || gsonSerializer == null || color == null || overlay == null || flag == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure needs to have gson serializer!");
        }
        return (T)BossBarUtils.bossBarToPlatform(this.bossBar, type, component, Reflect.fastInvoke(gsonSerializer, "gson"), flag, overlay, color);
    }

    public BossBarWrapper(BossBar bossBar) {
        this.bossBar = bossBar;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BossBarWrapper)) {
            return false;
        }
        BossBarWrapper other = (BossBarWrapper)o;
        BossBar this$bossBar = this.getBossBar();
        BossBar other$bossBar = other.getBossBar();
        return !(this$bossBar == null ? other$bossBar != null : !this$bossBar.equals(other$bossBar));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BossBar $bossBar = this.getBossBar();
        result = result * 59 + ($bossBar == null ? 43 : $bossBar.hashCode());
        return result;
    }

    public String toString() {
        return "BossBarWrapper(bossBar=" + this.getBossBar() + ")";
    }
}

