/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.identity.Identity;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.IdentityUtils;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class IdentityWrapper
implements Wrapper {
    private final Identity identity;

    @NotNull
    public Identity asIdentity() {
        return this.identity;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return (T)this.identity.uuid().toString();
        }
        if (UUID.class.isAssignableFrom(type)) {
            return (T)this.identity.uuid();
        }
        if (type.isInstance(this.identity)) {
            return (T)this.identity;
        }
        return (T)IdentityUtils.identityToPlatform(this.identity, type);
    }

    public IdentityWrapper(Identity identity) {
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IdentityWrapper)) {
            return false;
        }
        IdentityWrapper other = (IdentityWrapper)o;
        Identity this$identity = this.getIdentity();
        Identity other$identity = other.getIdentity();
        return !(this$identity == null ? other$identity != null : !this$identity.equals(other$identity));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Identity $identity = this.getIdentity();
        result = result * 59 + ($identity == null ? 43 : $identity.hashCode());
        return result;
    }

    public String toString() {
        return "IdentityWrapper(identity=" + this.getIdentity() + ")";
    }
}

