/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.sound.SoundStop;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.SoundUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SoundStopWrapper
implements Wrapper {
    private final SoundStop soundStop;

    @NotNull
    public SoundStop asSoundStop() {
        return this.soundStop;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type.isInstance(this.soundStop)) {
            return (T)this.soundStop;
        }
        List<String> generalPackageSplit = Arrays.asList(type.getPackageName().split("\\."));
        generalPackageSplit.remove(generalPackageSplit.size() - 1);
        String generalPackage = String.join((CharSequence)".", generalPackageSplit);
        Class keyClass = Reflect.getClassSafe(generalPackage + ".key.Key");
        Class sourceClass = Reflect.getClassSafe(generalPackage + ".sound.Sound$Source");
        if (keyClass == null || sourceClass == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure is badly relocated!");
        }
        return (T)SoundUtils.stopSoundToPlatform(this.soundStop, type, keyClass, sourceClass);
    }

    public SoundStopWrapper(SoundStop soundStop) {
        this.soundStop = soundStop;
    }

    public SoundStop getSoundStop() {
        return this.soundStop;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoundStopWrapper)) {
            return false;
        }
        SoundStopWrapper other = (SoundStopWrapper)o;
        SoundStop this$soundStop = this.getSoundStop();
        SoundStop other$soundStop = other.getSoundStop();
        return !(this$soundStop == null ? other$soundStop != null : !this$soundStop.equals(other$soundStop));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        SoundStop $soundStop = this.getSoundStop();
        result = result * 59 + ($soundStop == null ? 43 : $soundStop.hashCode());
        return result;
    }

    public String toString() {
        return "SoundStopWrapper(soundStop=" + this.getSoundStop() + ")";
    }
}

