/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.sound.Sound;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.SoundUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SoundWrapper
implements Wrapper {
    private final Sound sound;

    @NotNull
    public Sound asSound() {
        return this.sound;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (String.class.isAssignableFrom(type)) {
            return (T)this.sound.name().asString();
        }
        if (type.isInstance(this.sound)) {
            return (T)this.sound;
        }
        List<String> generalPackageSplit = Arrays.asList(type.getPackageName().split("\\."));
        generalPackageSplit.remove(generalPackageSplit.size() - 1);
        String generalPackage = String.join((CharSequence)".", generalPackageSplit);
        Class keyClass = Reflect.getClassSafe(generalPackage + ".key.Key");
        Class sourceClass = Reflect.getClassSafe(generalPackage + ".sound.Sound$Source");
        if (keyClass == null || sourceClass == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure is badly relocated!");
        }
        return (T)SoundUtils.soundToPlatform(this.sound, type, keyClass, sourceClass);
    }

    public SoundWrapper(Sound sound) {
        this.sound = sound;
    }

    public Sound getSound() {
        return this.sound;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SoundWrapper)) {
            return false;
        }
        SoundWrapper other = (SoundWrapper)o;
        Sound this$sound = this.getSound();
        Sound other$sound = other.getSound();
        return !(this$sound == null ? other$sound != null : !this$sound.equals(other$sound));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Sound $sound = this.getSound();
        result = result * 59 + ($sound == null ? 43 : $sound.hashCode());
        return result;
    }

    public String toString() {
        return "SoundWrapper(sound=" + this.getSound() + ")";
    }
}

