/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.adventure.wrapper;

import io.github.pronze.lib.kyori.adventure.title.Title;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.adventure.TitleUtils;
import io.github.pronze.lib.screaminglib.utils.reflect.Reflect;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class TitleWrapper
implements Wrapper {
    private final Title title;

    @NotNull
    public Title asTitle() {
        return this.title;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type.isInstance(this.title)) {
            return (T)this.title;
        }
        List<String> generalPackageSplit = Arrays.asList(type.getPackageName().split("\\."));
        generalPackageSplit.remove(generalPackageSplit.size() - 1);
        String generalPackage = String.join((CharSequence)".", generalPackageSplit);
        Class component = Reflect.getClassSafe(generalPackage + ".text.Component");
        Class gsonSerializer = Reflect.getClassSafe(generalPackage + ".text.serializer.gson.GsonComponentSerializer");
        Class times = Reflect.getClassSafe(type.getName() + "$Times");
        if (component == null || gsonSerializer == null || times == null) {
            throw new UnsupportedOperationException("Not supported! The target adventure needs to have gson serializer!");
        }
        return (T)TitleUtils.titleToPlatform(this.title, type, component, Reflect.fastInvoke(gsonSerializer, "gson"), times);
    }

    public TitleWrapper(Title title) {
        this.title = title;
    }

    public Title getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TitleWrapper)) {
            return false;
        }
        TitleWrapper other = (TitleWrapper)o;
        Title this$title = this.getTitle();
        Title other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Title $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "TitleWrapper(title=" + this.getTitle() + ")";
    }
}

