/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.data;

import io.github.pronze.lib.screaminglib.utils.data.DataContainer;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

class SimpleDataContainer
implements DataContainer {
    private final Map<String, Object> dataMap = new ConcurrentHashMap<String, Object>();

    SimpleDataContainer() {
    }

    static SimpleDataContainer get() {
        return new SimpleDataContainer();
    }

    @Override
    public Map<String, Object> getAll() {
        return Map.copyOf(this.dataMap);
    }

    @Override
    public <T> T get(String key) {
        if (this.dataMap.containsKey(key)) {
            return (T)this.dataMap.get(key);
        }
        throw new NullPointerException("Data for key " + key + " was not found!");
    }

    @Override
    public <T> Optional<T> getOptional(String key) {
        return Optional.ofNullable(this.dataMap.get(key));
    }

    @Override
    public boolean contains(String key) {
        return this.dataMap.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.dataMap.isEmpty();
    }

    @Override
    public void set(String key, Object data) {
        this.dataMap.put(key, data);
    }

    @Override
    public void add(String key, Object data) {
        this.dataMap.putIfAbsent(key, data);
    }
}

