/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.executor;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public final class ExecutorProvider {
    public static ExecutorService buildExecutor(String name) {
        return ExecutorProvider.buildExecutor(Runtime.getRuntime().availableProcessors(), name);
    }

    public static ExecutorService buildExecutor(int threadCount, String name) {
        return Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setNameFormat(name + " - #%d").setDaemon(true).build());
    }

    public static ScheduledExecutorService buildScheduledExecutor(String name) {
        return ExecutorProvider.buildScheduledExecutor(Runtime.getRuntime().availableProcessors(), name);
    }

    public static ScheduledExecutorService buildScheduledExecutor(int threadCount, String name) {
        return Executors.newScheduledThreadPool(threadCount, new ThreadFactoryBuilder().setNameFormat(name + " - #%d").setDaemon(true).build());
    }

    public static void destroyExecutor(ExecutorService executorService) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(20L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
                if (!executorService.awaitTermination(20L, TimeUnit.SECONDS)) {
                    throw new UnsupportedOperationException("ExecutorService did not terminated, something is wrong..");
                }
            }
        }
        catch (InterruptedException ie) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private ExecutorProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

