/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.key;

import io.github.pronze.lib.kyori.adventure.key.Key;
import io.github.pronze.lib.kyori.adventure.key.Namespaced;
import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class NamespacedMappingKey
implements MappingKey,
ComparableWrapper,
Namespaced,
Key {
    public static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?:(?<namespace>[A-Za-z0-9_.\\-]+):)?(?<key>[A-Za-z0-9_.\\-/ ]+)$");
    public static final Pattern VALID_NAMESPACE = Pattern.compile("^[a-z0-9_.\\-]+$");
    public static final Pattern VALID_KEY = Pattern.compile("^[a-z0-9_.\\-/]+$");
    private final String namespace;
    private final String key;

    public static Optional<NamespacedMappingKey> ofOptional(String combinedString) {
        Matcher matcher = RESOLUTION_PATTERN.matcher(combinedString);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String namespace = matcher.group("namespace") != null ? matcher.group("namespace").toLowerCase() : "minecraft";
        String key = matcher.group("key").replaceAll(" ", "_").toLowerCase();
        return NamespacedMappingKey.ofOptional(namespace, key);
    }

    public static NamespacedMappingKey of(String combinedString) {
        return NamespacedMappingKey.ofOptional(combinedString).orElseThrow(() -> new IllegalArgumentException(combinedString + " doesn't match validation patterns!"));
    }

    public static Optional<NamespacedMappingKey> ofOptional(String namespace, String key) {
        if (!VALID_NAMESPACE.matcher(namespace).matches() || !VALID_KEY.matcher(key).matches()) {
            return Optional.empty();
        }
        return Optional.of(new NamespacedMappingKey(namespace, key));
    }

    public static NamespacedMappingKey of(String namespace, String key) {
        return NamespacedMappingKey.ofOptional(namespace, key).orElseThrow(() -> new IllegalArgumentException(namespace + ":" + key + " doesn't match validation patterns!"));
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.key);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof NamespacedMappingKey) {
            return this.namespace.equals(((NamespacedMappingKey)object).namespace) && this.key.equals(((NamespacedMappingKey)object).key);
        }
        NamespacedMappingKey namespacedKey = NamespacedMappingKey.of(object.toString());
        return this.namespace.equals(namespacedKey.namespace) && this.key.equals(namespacedKey.key);
    }

    @Override
    @NotNull
    public String toString() {
        return this.namespace + ":" + this.key;
    }

    @Override
    public <T> T as(Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        if (type.isAssignableFrom(String.class)) {
            return (T)type.toString();
        }
        throw new UnsupportedOperationException("Can't convert wrapper to " + type.getName());
    }

    @Override
    @NotNull
    public String value() {
        return this.key;
    }

    @Override
    @NotNull
    public String asString() {
        return this.toString();
    }

    @Override
    @NotNull
    public String namespace() {
        return this.namespace;
    }

    @Override
    public boolean is(Object object) {
        return this.equals(object);
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getKey() {
        return this.key;
    }

    protected NamespacedMappingKey(String namespace, String key) {
        this.namespace = namespace;
        this.key = key;
    }
}

