/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.key;

import io.github.pronze.lib.screaminglib.utils.key.MappingKey;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class NumericMappingKey
implements MappingKey {
    private final int number;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof NumericMappingKey) {
            return this.number == ((NumericMappingKey)object).number;
        }
        try {
            int number2 = Integer.parseInt(object.toString());
            return number2 == this.number;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    @Override
    @NotNull
    public String toString() {
        return String.valueOf(this.number);
    }

    public int getNumber() {
        return this.number;
    }

    private NumericMappingKey(int number) {
        this.number = number;
    }

    public static NumericMappingKey of(int number) {
        return new NumericMappingKey(number);
    }
}

