/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.logger;

import io.github.pronze.lib.screaminglib.utils.BasicWrapper;
import io.github.pronze.lib.screaminglib.utils.Pair;
import io.github.pronze.lib.screaminglib.utils.logger.LoggerWrapper;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JULLoggerWrapper
extends BasicWrapper<Logger>
implements LoggerWrapper {
    public JULLoggerWrapper(Logger wrappedObject) {
        super(wrappedObject);
    }

    @Override
    public String getName() {
        return ((Logger)this.wrappedObject).getName();
    }

    @Override
    public boolean isTraceEnabled() {
        return ((Logger)this.wrappedObject).isLoggable(Level.FINEST);
    }

    @Override
    public void trace(String msg) {
        ((Logger)this.wrappedObject).log(Level.FINEST, msg);
    }

    @Override
    public void trace(String format, Object argument, Throwable throwable) {
        Pair<String, Throwable> msg = this.getMsg(format, new Object[]{argument}, throwable);
        ((Logger)this.wrappedObject).log(Level.FINEST, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void trace(String format, Object ... arguments) {
        Pair<String, Throwable> msg = this.getMsg(format, Arrays.asList(arguments));
        ((Logger)this.wrappedObject).log(Level.FINEST, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void trace(String msg, Throwable t) {
        ((Logger)this.wrappedObject).log(Level.FINEST, msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return ((Logger)this.wrappedObject).isLoggable(Level.FINE);
    }

    @Override
    public void debug(String msg) {
        ((Logger)this.wrappedObject).log(Level.FINE, msg);
    }

    @Override
    public void debug(String format, Object argument, Throwable throwable) {
        Pair<String, Throwable> msg = this.getMsg(format, new Object[]{argument}, throwable);
        ((Logger)this.wrappedObject).log(Level.FINE, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void debug(String format, Object ... arguments) {
        Pair<String, Throwable> msg = this.getMsg(format, Arrays.asList(arguments));
        ((Logger)this.wrappedObject).log(Level.FINE, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void debug(String msg, Throwable t) {
        ((Logger)this.wrappedObject).log(Level.FINE, msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return ((Logger)this.wrappedObject).isLoggable(Level.INFO);
    }

    @Override
    public void info(String msg) {
        ((Logger)this.wrappedObject).log(Level.INFO, msg);
    }

    @Override
    public void info(String format, Object argument, Throwable throwable) {
        Pair<String, Throwable> msg = this.getMsg(format, new Object[]{argument}, throwable);
        ((Logger)this.wrappedObject).log(Level.INFO, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void info(String format, Object ... arguments) {
        Pair<String, Throwable> msg = this.getMsg(format, Arrays.asList(arguments));
        ((Logger)this.wrappedObject).log(Level.INFO, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void info(String msg, Throwable t) {
        ((Logger)this.wrappedObject).log(Level.INFO, msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return ((Logger)this.wrappedObject).isLoggable(Level.WARNING);
    }

    @Override
    public void warn(String msg) {
        ((Logger)this.wrappedObject).log(Level.WARNING, msg);
    }

    @Override
    public void warn(String format, Object ... arguments) {
        Pair<String, Throwable> msg = this.getMsg(format, Arrays.asList(arguments));
        ((Logger)this.wrappedObject).log(Level.WARNING, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void warn(String format, Object argument, Throwable throwable) {
        Pair<String, Throwable> msg = this.getMsg(format, new Object[]{argument}, throwable);
        ((Logger)this.wrappedObject).log(Level.WARNING, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void warn(String msg, Throwable t) {
        ((Logger)this.wrappedObject).log(Level.WARNING, msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return ((Logger)this.wrappedObject).isLoggable(Level.SEVERE);
    }

    @Override
    public void error(String msg) {
        ((Logger)this.wrappedObject).log(Level.SEVERE, msg);
    }

    @Override
    public void error(String format, Object argument, Throwable throwable) {
        Pair<String, Throwable> msg = this.getMsg(format, new Object[]{argument}, throwable);
        ((Logger)this.wrappedObject).log(Level.SEVERE, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void error(String format, Object ... arguments) {
        Pair<String, Throwable> msg = this.getMsg(format, Arrays.asList(arguments));
        ((Logger)this.wrappedObject).log(Level.SEVERE, msg.getFirst(), msg.getSecond());
    }

    @Override
    public void error(String msg, Throwable t) {
        ((Logger)this.wrappedObject).log(Level.SEVERE, msg, t);
    }

    private Pair<String, Throwable> getMsg(String msg, List<Object> args) {
        Optional<Throwable> throwableCandidate = args.stream().filter(o -> o instanceof Throwable).findFirst().map(o -> (Throwable)o);
        throwableCandidate.ifPresent(args::remove);
        return this.getMsg(msg, args.toArray(), throwableCandidate.orElse(null));
    }

    private Pair<String, Throwable> getMsg(String msg, Object[] args, Throwable throwable) {
        if (msg == null || args == null || args.length == 0) {
            return Pair.of(msg, throwable);
        }
        MessageFormat format = new MessageFormat(msg);
        return Pair.of(format.format(args), throwable);
    }
}

