/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.math;

import io.github.pronze.lib.screaminglib.utils.ProtoLocation;
import io.github.pronze.lib.screaminglib.utils.ProtoVector3D;
import io.github.pronze.lib.screaminglib.utils.ProtoVector3Df;
import io.github.pronze.lib.screaminglib.utils.ProtoWrapper;
import org.jetbrains.annotations.NotNull;

public class Vector3Df
implements Cloneable,
ProtoWrapper<ProtoVector3Df> {
    private float x;
    private float y;
    private float z;

    public static Vector3Df unwrap(ProtoVector3Df wrapped) {
        return new Vector3Df(wrapped.getX(), wrapped.getY(), wrapped.getZ());
    }

    public static Vector3Df unwrap(ProtoVector3D wrapped) {
        return new Vector3Df((float)wrapped.getX(), (float)wrapped.getY(), (float)wrapped.getZ());
    }

    public static Vector3Df unwrap(ProtoLocation wrapped) {
        return new Vector3Df((float)wrapped.getX(), (float)wrapped.getY(), (float)wrapped.getZ());
    }

    public Vector3Df clone() {
        return new Vector3Df(this.x, this.y, this.z);
    }

    public Vector3Df add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(@NotNull Vector3Df o) {
        return (float)Math.sqrt(this.distanceSquared(o));
    }

    public float distanceSquared(@NotNull Vector3Df o) {
        float deltaX = this.x - o.x;
        float deltaY = this.y - o.y;
        float deltaZ = this.z - o.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    @NotNull
    public Vector3Df normalize() {
        float length = this.length();
        this.x /= length;
        this.y /= length;
        this.z /= length;
        return this;
    }

    @Override
    public ProtoVector3Df asProto() {
        return ProtoVector3Df.newBuilder().setX(this.x).setY(this.y).setZ(this.z).build();
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getZ() {
        return this.z;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector3Df)) {
            return false;
        }
        Vector3Df other = (Vector3Df)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Float.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Float.compare(this.getZ(), other.getZ()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector3Df;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.getX());
        result = result * 59 + Float.floatToIntBits(this.getY());
        result = result * 59 + Float.floatToIntBits(this.getZ());
        return result;
    }

    public String toString() {
        return "Vector3Df(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    public Vector3Df() {
    }

    public Vector3Df(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

