/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.utils.math;

import org.jetbrains.annotations.NotNull;

public class Vector3Di
implements Cloneable {
    private int x;
    private int y;
    private int z;

    public Vector3Di clone() {
        return new Vector3Di(this.x, this.y, this.z);
    }

    public Vector3Di add(float x, float y, float z) {
        this.x = (int)((float)this.x + x);
        this.y = (int)((float)this.y + y);
        this.z = (int)((float)this.z + z);
        return this;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float distance(@NotNull Vector3Di o) {
        return (float)Math.sqrt(this.distanceSquared(o));
    }

    public int distanceSquared(@NotNull Vector3Di o) {
        int deltaX = this.x - o.x;
        int deltaY = this.y - o.y;
        int deltaZ = this.z - o.z;
        return deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
    }

    @NotNull
    public Vector3Di normalize() {
        float length = this.length();
        this.x = (int)((float)this.x / length);
        this.y = (int)((float)this.y / length);
        this.z = (int)((float)this.z / length);
        return this;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Vector3Di setX(int x) {
        this.x = x;
        return this;
    }

    public Vector3Di setY(int y) {
        this.y = y;
        return this;
    }

    public Vector3Di setZ(int z) {
        this.z = z;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Vector3Di)) {
            return false;
        }
        Vector3Di other = (Vector3Di)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getX() != other.getX()) {
            return false;
        }
        if (this.getY() != other.getY()) {
            return false;
        }
        return this.getZ() == other.getZ();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Vector3Di;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getX();
        result = result * 59 + this.getY();
        result = result * 59 + this.getZ();
        return result;
    }

    public String toString() {
        return "Vector3Di(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }

    public Vector3Di() {
    }

    public Vector3Di(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }
}

