/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.visuals.impl;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.visuals.Visual;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractVisual<T extends Visual<T>>
implements Visual<T> {
    protected final List<PlayerWrapper> viewers;
    protected final UUID uuid;
    protected volatile boolean visible;

    public AbstractVisual(UUID uuid) {
        this.uuid = uuid;
        this.visible = false;
        this.viewers = new CopyOnWriteArrayList<PlayerWrapper>();
    }

    protected abstract void update0();

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Collection<PlayerWrapper> getViewers() {
        return List.copyOf(this.viewers);
    }

    @Override
    public T addViewer(PlayerWrapper viewer) {
        if (!this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
            this.onViewerAdded(viewer, true);
        }
        return (T)this;
    }

    @Override
    public T removeViewer(PlayerWrapper viewer) {
        if (this.viewers.contains(viewer)) {
            this.viewers.remove(viewer);
            this.onViewerRemoved(viewer, false);
        }
        return (T)this;
    }

    @Override
    public T clearViewers() {
        this.hide();
        this.viewers.clear();
        return (T)this;
    }

    @Override
    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    @Override
    public boolean isShown() {
        return this.visible;
    }

    @Override
    public boolean isVisibleToPlayer(PlayerWrapper player) {
        return this.viewers.contains(player);
    }
}

