/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world;

import io.github.pronze.lib.configurate.objectmapping.ConfigSerializable;
import io.github.pronze.lib.screaminglib.block.BlockHolder;
import io.github.pronze.lib.screaminglib.entity.EntityBasic;
import io.github.pronze.lib.screaminglib.particle.ParticleHolder;
import io.github.pronze.lib.screaminglib.utils.BlockFace;
import io.github.pronze.lib.screaminglib.utils.MathUtils;
import io.github.pronze.lib.screaminglib.utils.ProtoLocation;
import io.github.pronze.lib.screaminglib.utils.ProtoVector3D;
import io.github.pronze.lib.screaminglib.utils.ProtoVector3Df;
import io.github.pronze.lib.screaminglib.utils.ProtoWrapper;
import io.github.pronze.lib.screaminglib.utils.Wrapper;
import io.github.pronze.lib.screaminglib.utils.math.Vector3D;
import io.github.pronze.lib.screaminglib.utils.math.Vector3Df;
import io.github.pronze.lib.screaminglib.world.LocationMapper;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import io.github.pronze.lib.screaminglib.world.chunk.ChunkHolder;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

@ConfigSerializable
public class LocationHolder
implements Wrapper,
ProtoWrapper<ProtoLocation>,
Serializable {
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;
    private WorldHolder world;

    public LocationHolder(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public LocationHolder add(double x, double y, double z) {
        LocationHolder clone = this.clone();
        clone.x += x;
        clone.y += y;
        clone.z += z;
        return clone;
    }

    public LocationHolder add(LocationHolder holder) {
        return this.add(holder.getX(), holder.getY(), holder.getZ());
    }

    public LocationHolder add(Vector3D vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    public LocationHolder add(Vector3Df vec) {
        return this.add(vec.getX(), vec.getY(), vec.getZ());
    }

    public LocationHolder add(BlockFace blockFace) {
        return this.add(blockFace.getBlockDirection());
    }

    public LocationHolder add(BlockFace blockFace, int distance) {
        return this.add(blockFace.getBlockDirection().multiply(distance));
    }

    @NotNull
    public LocationHolder subtract(double x, double y, double z) {
        LocationHolder clone = this.clone();
        clone.x -= x;
        clone.y -= y;
        clone.z -= z;
        return clone;
    }

    public LocationHolder subtract(LocationHolder holder) {
        return this.subtract(holder.getX(), holder.getY(), holder.getZ());
    }

    public LocationHolder subtract(Vector3D vec) {
        return this.subtract(vec.getX(), vec.getY(), vec.getZ());
    }

    public LocationHolder subtract(Vector3Df vec) {
        return this.subtract(vec.getX(), vec.getY(), vec.getZ());
    }

    public LocationHolder subtract(BlockFace blockFace) {
        return this.subtract(blockFace.getBlockDirection());
    }

    public LocationHolder subtract(BlockFace blockFace, int distance) {
        return this.subtract(blockFace.getBlockDirection().multiply(distance));
    }

    @Override
    public <T> T as(Class<T> type) {
        return LocationMapper.convert(this, type);
    }

    public double getDistanceSquared(@NotNull LocationHolder holder) {
        return MathUtils.square(this.getX() - holder.getX()) + MathUtils.square(this.getY() - holder.getY()) + MathUtils.square(this.getZ() - holder.getZ());
    }

    public Vector3D asVector() {
        return new Vector3D(this.x, this.y, this.z);
    }

    public Vector3Df asVectorf() {
        return new Vector3Df((float)this.x, (float)this.y, (float)this.z);
    }

    public ProtoVector3D asWrappedVector() {
        return this.asVector().asProto();
    }

    public ProtoVector3Df asWrappedVectorf() {
        return this.asVectorf().asProto();
    }

    public int getBlockX() {
        return (int)Math.floor(this.x);
    }

    public int getBlockY() {
        return (int)Math.floor(this.y);
    }

    public int getBlockZ() {
        return (int)Math.floor(this.z);
    }

    public Vector3D getFacingDirection() {
        Vector3D vector = new Vector3D();
        vector.setY(-Math.sin(Math.toRadians(this.pitch)));
        double xz = Math.cos(Math.toRadians(this.pitch));
        vector.setX(-xz * Math.sin(Math.toRadians(this.yaw)));
        vector.setZ(xz * Math.cos(Math.toRadians(this.yaw)));
        return vector;
    }

    public BlockHolder getBlock() {
        return this.as(BlockHolder.class);
    }

    public ChunkHolder getChunk() {
        return this.getWorld().getChunkAt(this).orElseThrow();
    }

    public void sendParticle(ParticleHolder particle) {
        this.getWorld().sendParticle(particle, this);
    }

    public BlockHolder getHighestBlock() {
        return this.getWorld().getHighestBlockAt(this.getBlockX(), this.getBlockZ());
    }

    public int getHighestY() {
        return this.getWorld().getHighestYAt(this.getBlockX(), this.getBlockZ());
    }

    public LocationHolder clone() {
        LocationHolder location = new LocationHolder();
        location.setX(this.getX());
        location.setY(this.getY());
        location.setZ(this.getZ());
        location.setPitch(this.getPitch());
        location.setYaw(this.getYaw());
        location.setWorld(this.getWorld());
        return location;
    }

    public List<EntityBasic> getNearbyEntities(int radius) {
        return this.world.getEntities().stream().filter(e -> this.isInRange(e.getLocation(), radius)).collect(Collectors.toList());
    }

    public <T extends EntityBasic> List<T> getNearbyEntitiesByClass(Class<T> clazz, int radius) {
        return this.world.getEntitiesByClass(clazz).stream().filter(e -> this.isInRange(e.getLocation(), radius)).collect(Collectors.toList());
    }

    public boolean isWorldSame(LocationHolder holder) {
        return this.getWorld().equals(holder.getWorld());
    }

    public boolean isInRange(LocationHolder holder, int distance) {
        return this.getDistanceSquared(holder) < (double)distance;
    }

    public boolean outOfRange(LocationHolder holder, int distance) {
        return this.getDistanceSquared(holder) >= (double)distance;
    }

    @NotNull
    public LocationHolder setDirection(@NotNull Vector3D vector) {
        double _2PI = Math.PI * 2;
        double x = vector.getX();
        double z = vector.getZ();
        if (x == 0.0 && z == 0.0) {
            this.pitch = vector.getY() > 0.0 ? -90.0f : 90.0f;
            return this;
        }
        double theta = Math.atan2(-x, z);
        this.yaw = (float)Math.toDegrees((theta + Math.PI * 2) % (Math.PI * 2));
        double x2 = Math.pow(x, 2.0);
        double z2 = Math.pow(z, 2.0);
        double xz = Math.sqrt(x2 + z2);
        this.pitch = (float)Math.toDegrees(Math.atan(-vector.getY() / xz));
        return this;
    }

    @Override
    public ProtoLocation asProto() {
        return ProtoLocation.newBuilder().setX(this.x).setY(this.y).setZ(this.z).setPitch(this.pitch).setYaw(this.yaw).setWorldUuid(this.world.getUuid().toString()).build();
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public WorldHolder getWorld() {
        return this.world;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public void setWorld(WorldHolder world) {
        this.world = world;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationHolder)) {
            return false;
        }
        LocationHolder other = (LocationHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        WorldHolder this$world = this.getWorld();
        WorldHolder other$world = other.getWorld();
        return !(this$world == null ? other$world != null : !this$world.equals(other$world));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationHolder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        WorldHolder $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        return result;
    }

    public String toString() {
        return "LocationHolder(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", world=" + this.getWorld() + ")";
    }

    public LocationHolder(double x, double y, double z, float yaw, float pitch, WorldHolder world) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.world = world;
    }

    public LocationHolder() {
    }
}

