/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world;

import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.world.WorldHolder;
import java.util.Optional;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;

@AbstractService
public abstract class WorldMapper {
    protected BidirectionalConverter<WorldHolder> converter = BidirectionalConverter.build().registerP2W(WorldHolder.class, e -> e);
    private static WorldMapper mapping;

    @ApiStatus.Internal
    public WorldMapper() {
        if (mapping != null) {
            throw new UnsupportedOperationException("WorldMapper is already initialized.");
        }
        mapping = this;
    }

    public static Optional<WorldHolder> resolve(Object obj) {
        if (mapping == null) {
            throw new UnsupportedOperationException("WorldMapper is not initialized yet.");
        }
        return WorldMapper.mapping.converter.convertOptional(obj);
    }

    public static <T> WorldHolder wrapWorld(T input) {
        return WorldMapper.resolve(input).orElseThrow();
    }

    public static <T> T convert(WorldHolder holder, Class<T> newType) {
        if (mapping == null) {
            throw new UnsupportedOperationException("WorldMapper is not initialized yet.");
        }
        return WorldMapper.mapping.converter.convert(holder, newType);
    }

    public static Optional<WorldHolder> getWorld(UUID uuid) {
        if (mapping == null) {
            throw new UnsupportedOperationException("WorldMapper is not initialized yet.");
        }
        return mapping.getWorld0(uuid);
    }

    public static Optional<WorldHolder> getWorld(String name) {
        if (mapping == null) {
            throw new UnsupportedOperationException("WorldMapper is not initialized yet.");
        }
        return mapping.getWorld0(name);
    }

    protected abstract Optional<WorldHolder> getWorld0(UUID var1);

    protected abstract Optional<WorldHolder> getWorld0(String var1);
}

