/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.dimension;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.DimensionHolderSerializer;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import io.github.pronze.lib.screaminglib.world.dimension.DimensionHolder;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class DimensionMapping
extends AbstractTypeMapper<DimensionHolder> {
    private static DimensionMapping dimensionMapping;
    protected final BidirectionalConverter<DimensionHolder> dimensionConverter = BidirectionalConverter.build().registerP2W(DimensionHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return DimensionHolderSerializer.INSTANCE.deserialize((Type)((Object)DimensionHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public DimensionMapping() {
        if (dimensionMapping != null) {
            throw new UnsupportedOperationException("DimensionMapping is already initialized!");
        }
        dimensionMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.DIMENSION)
    @OfMethodAlternative(value=DimensionHolder.class, methodName="ofOptional")
    public static Optional<DimensionHolder> resolve(Object dimension) {
        if (dimensionMapping == null) {
            throw new UnsupportedOperationException("DimensionMapping is not initialized yet.");
        }
        if (dimension == null) {
            return Optional.empty();
        }
        return DimensionMapping.dimensionMapping.dimensionConverter.convertOptional(dimension).or(() -> dimensionMapping.resolveFromMapping(dimension));
    }

    @OfMethodAlternative(value=DimensionHolder.class, methodName="all")
    public static List<DimensionHolder> getValues() {
        if (dimensionMapping == null) {
            throw new UnsupportedOperationException("DimensionMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(DimensionMapping.dimensionMapping.values);
    }
}

