/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.gamerule;

import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.world.gamerule.GameRuleMapping;
import java.util.List;
import java.util.Optional;

public interface GameRuleHolder
extends ComparableWrapper {
    public String platformName();

    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_RULE)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_RULE)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_RULE)
    public static GameRuleHolder of(Object gameRule) {
        return GameRuleHolder.ofOptional(gameRule).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_RULE)
    public static Optional<GameRuleHolder> ofOptional(Object gameRule) {
        if (gameRule instanceof GameRuleHolder) {
            return Optional.of((GameRuleHolder)gameRule);
        }
        return GameRuleMapping.resolve(gameRule);
    }

    public static List<GameRuleHolder> all() {
        return GameRuleMapping.getValues();
    }
}

