/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.gamerule;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.GameRuleHolderSerializer;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import io.github.pronze.lib.screaminglib.world.gamerule.GameRuleHolder;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class GameRuleMapping
extends AbstractTypeMapper<GameRuleHolder> {
    private static GameRuleMapping gameRuleMapping;
    protected final BidirectionalConverter<GameRuleHolder> gameRuleConverter = BidirectionalConverter.build().registerP2W(GameRuleHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return GameRuleHolderSerializer.INSTANCE.deserialize((Type)((Object)GameRuleHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public GameRuleMapping() {
        if (gameRuleMapping != null) {
            throw new UnsupportedOperationException("GameRuleMapping is already initialized!");
        }
        gameRuleMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.GAME_RULE)
    @OfMethodAlternative(value=GameRuleHolder.class, methodName="ofOptional")
    public static Optional<GameRuleHolder> resolve(Object gameRule) {
        if (gameRuleMapping == null) {
            throw new UnsupportedOperationException("GameRuleMapping is not initialized yet.");
        }
        if (gameRule == null) {
            return Optional.empty();
        }
        return GameRuleMapping.gameRuleMapping.gameRuleConverter.convertOptional(gameRule).or(() -> gameRuleMapping.resolveFromMapping(gameRule));
    }

    @OfMethodAlternative(value=GameRuleHolder.class, methodName="all")
    public static List<GameRuleHolder> getValues() {
        if (gameRuleMapping == null) {
            throw new UnsupportedOperationException("GameRuleMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(GameRuleMapping.gameRuleMapping.values);
    }
}

