/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.weather;

import io.github.pronze.lib.screaminglib.utils.ComparableWrapper;
import io.github.pronze.lib.screaminglib.utils.RawValueHolder;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.world.weather.WeatherMapping;
import java.util.List;
import java.util.Optional;

public interface WeatherHolder
extends ComparableWrapper,
RawValueHolder {
    @Deprecated(forRemoval=true)
    default public String getPlatformName() {
        return this.platformName();
    }

    public String platformName();

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.WEATHER)
    public boolean is(Object var1);

    @Override
    @CustomAutocompletion(value=CustomAutocompletion.Type.WEATHER)
    public boolean is(Object ... var1);

    @CustomAutocompletion(value=CustomAutocompletion.Type.WEATHER)
    public static WeatherHolder of(Object weather) {
        return WeatherHolder.ofOptional(weather).orElseThrow();
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.WEATHER)
    public static Optional<WeatherHolder> ofOptional(Object weather) {
        if (weather instanceof WeatherHolder) {
            return Optional.of((WeatherHolder)weather);
        }
        return WeatherMapping.resolve(weather);
    }

    public static List<WeatherHolder> all() {
        return WeatherMapping.getValues();
    }
}

