/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.screaminglib.world.weather;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.configurate.WeatherHolderSerializer;
import io.github.pronze.lib.screaminglib.utils.BidirectionalConverter;
import io.github.pronze.lib.screaminglib.utils.annotations.AbstractService;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.CustomAutocompletion;
import io.github.pronze.lib.screaminglib.utils.annotations.ide.OfMethodAlternative;
import io.github.pronze.lib.screaminglib.utils.mapper.AbstractTypeMapper;
import io.github.pronze.lib.screaminglib.world.weather.WeatherHolder;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.ApiStatus;

@AbstractService(pattern="^(?<basePackage>.+)\\.(?<subPackage>[^\\.]+\\.[^\\.]+)\\.(?<className>.+)$")
public abstract class WeatherMapping
extends AbstractTypeMapper<WeatherHolder> {
    private static WeatherMapping weatherMapping;
    protected final BidirectionalConverter<WeatherHolder> weatherConverter = BidirectionalConverter.build().registerP2W(WeatherHolder.class, d -> d).registerP2W(ConfigurationNode.class, node -> {
        try {
            return WeatherHolderSerializer.INSTANCE.deserialize((Type)((Object)WeatherHolder.class), (ConfigurationNode)node);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
            return null;
        }
    });

    @ApiStatus.Internal
    public WeatherMapping() {
        if (weatherMapping != null) {
            throw new UnsupportedOperationException("WeatherMapping is already initialized!");
        }
        weatherMapping = this;
    }

    @CustomAutocompletion(value=CustomAutocompletion.Type.WEATHER)
    @OfMethodAlternative(value=WeatherHolder.class, methodName="ofOptional")
    public static Optional<WeatherHolder> resolve(Object weather) {
        if (weatherMapping == null) {
            throw new UnsupportedOperationException("WeatherMapping is not initialized yet.");
        }
        if (weather == null) {
            return Optional.empty();
        }
        return WeatherMapping.weatherMapping.weatherConverter.convertOptional(weather).or(() -> weatherMapping.resolveFromMapping(weather));
    }

    @OfMethodAlternative(value=WeatherHolder.class, methodName="all")
    public static List<WeatherHolder> getValues() {
        if (weatherMapping == null) {
            throw new UnsupportedOperationException("WeatherMapping is not initialized yet.");
        }
        return Collections.unmodifiableList(WeatherMapping.weatherMapping.values);
    }
}

