/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.action;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ClickType;
import io.github.pronze.lib.simpleinventories.events.OnTradeEvent;
import io.github.pronze.lib.simpleinventories.events.PostClickEvent;
import io.github.pronze.lib.simpleinventories.events.PreClickEvent;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.IdentifiableEntry;
import io.github.pronze.lib.simpleinventories.inventory.LocalOptions;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Price;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.render.InventoryRenderer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class ClickActionHandler {
    protected void handleAction(InventoryRenderer inventoryRenderer, int slot, ClickType clickType) {
        List<Price> list;
        Optional<SubInventory> opt;
        PlayerWrapper playerWrapper = inventoryRenderer.getPlayer();
        SubInventory subInventory = inventoryRenderer.getSubInventory();
        LocalOptions options = subInventory.getLocalOptions();
        PlayerItemInfo playerItemInfo = inventoryRenderer.getItemInfoMap().get(slot);
        IdentifiableEntry parentItem = subInventory.getItemOwner();
        PreClickEvent preClickEvent = new PreClickEvent(playerWrapper, playerItemInfo, clickType, subInventory);
        if (playerItemInfo != null) {
            playerItemInfo.getOriginal().getEventManager().fireEvent(preClickEvent);
        } else {
            subInventory.getInventorySet().getEventManager().fireEvent(preClickEvent);
        }
        if (preClickEvent.isCancelled()) {
            inventoryRenderer.close();
            return;
        }
        if (playerItemInfo == null) {
            if (slot == options.getRenderHeaderStart()) {
                if (!subInventory.isMain() && parentItem != null) {
                    SubInventory parent = parentItem.getParent();
                    int pageOfParent = parentItem instanceof GenericItemInfo ? ((GenericItemInfo)parentItem).getPosition() / parent.getLocalOptions().getItemsOnPage() : 0;
                    inventoryRenderer.jump(parent, pageOfParent);
                }
            } else if (slot == options.getRenderFooterStart()) {
                inventoryRenderer.previousPage();
            } else if (slot == options.getRenderFooterStart() + options.getItemsOnRow() - 1) {
                inventoryRenderer.nextPage();
            }
            return;
        }
        if (playerItemInfo.isDisabled()) {
            return;
        }
        if (playerItemInfo.hasChildInventory()) {
            inventoryRenderer.jump(playerItemInfo.getChildInventory());
            return;
        }
        if (playerItemInfo.getOriginal().hasBook()) {
            inventoryRenderer.close();
            playerWrapper.openBook(playerItemInfo.getOriginal().getBook());
            return;
        }
        if (playerItemInfo.getOriginal().getLocate() != null && (opt = playerItemInfo.getOriginal().getLocate().resolve()).isPresent()) {
            inventoryRenderer.jump(opt.get());
            return;
        }
        if (playerItemInfo.getFormat().isGenericShop() && !playerItemInfo.getOriginal().getPrices().isEmpty() && !(list = playerItemInfo.getOriginal().getPrices().stream().map(price -> {
            Price price1 = price.clone();
            if (price1.getCurrency() == null) {
                price1.setCurrency(playerItemInfo.getOriginal().getDefaultCurrency());
            }
            if (price1.getCurrency() == null && playerItemInfo.getFormat().isGenericShopPriceTypeRequired()) {
                price1 = null;
            }
            return price1;
        }).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            OnTradeEvent tradeEvent = new OnTradeEvent(playerWrapper, list, playerItemInfo.getOriginal().getItem().clone(), playerItemInfo, clickType);
            playerItemInfo.getOriginal().getEventManager().fireEvent(tradeEvent);
            if (inventoryRenderer.isOpened()) {
                inventoryRenderer.render();
            }
            return;
        }
        if (!playerItemInfo.getOriginal().getExecutions().isEmpty()) {
            playerItemInfo.getOriginal().getExecutions().forEach(s -> {
                if (s.startsWith("console:")) {
                    if (playerItemInfo.getFormat().isAllowAccessToConsole()) {
                        String command = s.split(":", 2)[1];
                        this.dispatchConsoleCommand(command);
                    }
                } else if (s.startsWith("bungee:") || s.startsWith("proxy:")) {
                    if (playerItemInfo.getFormat().isAllowBungeecordPlayerSending()) {
                        String server = s.split(":", 2)[1];
                        this.movePlayerOnProxy(playerWrapper, server);
                    }
                } else {
                    String command = s.startsWith("player:") ? s.split(":", 2)[1] : s;
                    this.dispatchPlayerCommand(playerWrapper, command);
                }
            });
        }
        PostClickEvent postClickEvent = new PostClickEvent(playerWrapper, playerItemInfo, clickType, subInventory);
        playerItemInfo.getOriginal().getEventManager().fireEvent(postClickEvent);
        if (inventoryRenderer.isOpened()) {
            inventoryRenderer.render();
        }
    }

    protected abstract void dispatchPlayerCommand(PlayerWrapper var1, String var2);

    protected abstract void dispatchConsoleCommand(String var1);

    protected abstract void movePlayerOnProxy(PlayerWrapper var1, String var2);
}

