/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.screaminglib.utils.ConsumerExecutor;
import io.github.pronze.lib.simpleinventories.builder.BuilderUtils;
import io.github.pronze.lib.simpleinventories.builder.CategoryBuilder;
import io.github.pronze.lib.simpleinventories.builder.ItemInfoBuilder;
import io.github.pronze.lib.simpleinventories.builder.QueueBuilder;
import io.github.pronze.lib.simpleinventories.inventory.Clone;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.HiddenCategory;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.Insert;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.Queueable;
import io.github.pronze.lib.simpleinventories.inventory.SimpleItemQueue;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.inventory.SubInventoryLike;
import java.util.List;
import java.util.function.Consumer;
import lombok.NonNull;

public abstract class AbstractQueueBuilder<T extends AbstractQueueBuilder<T>> {
    public T category(Object material) {
        this.item(material);
        return this.self();
    }

    public T category(Object material, Consumer<ItemInfoBuilder> consumer) {
        this.item(material, consumer);
        return this.self();
    }

    public T item(Object material) {
        GenericItemInfo itemInfo = this.build(material);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T item(Object material, Consumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = this.build(material);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        ConsumerExecutor.execute(consumer, builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T cosmetic() {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink("cosmetic");
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T cosmetic(Consumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink("cosmetic");
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        ConsumerExecutor.execute(consumer, builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T itemClone(String link) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink(link);
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T itemClone(String link, Consumer<ItemInfoBuilder> consumer) {
        GenericItemInfo itemInfo = new GenericItemInfo(this.getFormat());
        Clone clone = new Clone();
        clone.setCloneLink(link);
        itemInfo.setRequestedClone(clone);
        this.putObjectToQueue(itemInfo);
        ItemInfoBuilder builder = ItemInfoBuilder.of(itemInfo);
        ConsumerExecutor.execute(consumer, builder);
        builder.processItemBuilderIfOpened();
        return this.self();
    }

    public T include(String include) {
        this.putObjectToQueue(Include.of(include));
        return this.self();
    }

    public T include(Include include) {
        this.putObjectToQueue(include);
        return this.self();
    }

    public T hidden(String id, Consumer<CategoryBuilder> consumer) {
        HiddenCategory itemInfo = new HiddenCategory(this.getFormat(), id);
        itemInfo.setChildInventory(new SubInventory(false, itemInfo, this.getFormat()));
        this.putObjectToQueue(itemInfo);
        ConsumerExecutor.execute(consumer, CategoryBuilder.of(itemInfo.getChildInventory()));
        return this.self();
    }

    public T hidden(String id) {
        HiddenCategory itemInfo = new HiddenCategory(this.getFormat(), id);
        itemInfo.setChildInventory(new SubInventory(false, itemInfo, this.getFormat()));
        this.putObjectToQueue(itemInfo);
        return this.self();
    }

    public T insert(String link, Consumer<QueueBuilder> consumer) {
        SimpleItemQueue prebuiltInventory = SimpleItemQueue.of();
        Insert insert = new Insert(link, prebuiltInventory);
        this.putObjectToQueue(insert);
        ConsumerExecutor.execute(consumer, QueueBuilder.of(this.getFormat(), prebuiltInventory));
        return this.self();
    }

    public T insert(String link, SubInventoryLike<?> prebuiltInventory) {
        Insert insert = new Insert(link, prebuiltInventory);
        this.putObjectToQueue(insert);
        return this.self();
    }

    public T insert(List<String> links, Consumer<QueueBuilder> consumer) {
        SimpleItemQueue prebuiltInventory = SimpleItemQueue.of();
        ConsumerExecutor.execute(consumer, QueueBuilder.of(this.getFormat(), prebuiltInventory));
        return this.insert(links, prebuiltInventory);
    }

    public T insert(List<String> links, SubInventoryLike<?> prebuiltInventory) {
        links.forEach(s -> this.insert((String)s, prebuiltInventory));
        return this.self();
    }

    protected GenericItemInfo build(Object stack) {
        return BuilderUtils.buildItem(this.getFormat(), stack);
    }

    public T call(Consumer<T> consumer) {
        ConsumerExecutor.execute(consumer, this.self());
        return this.self();
    }

    protected T self() {
        return (T)this;
    }

    protected abstract void putObjectToQueue(@NonNull Queueable var1);

    protected abstract InventorySet getFormat();
}

