/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import java.util.List;
import java.util.function.Consumer;

public class AnimationBuilder {
    private final List<Item> stacks;

    public AnimationBuilder stack(Object material) {
        this.stacks.add(ItemFactory.build(material).orElse(ItemFactory.getAir()));
        return this;
    }

    public AnimationBuilder stack(Object material, Consumer<ItemBuilder> consumer) {
        this.stacks.add(ItemFactory.build(material, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public AnimationBuilder stack(Consumer<ItemBuilder> consumer) {
        this.stacks.add(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public AnimationBuilder clear() {
        this.stacks.clear();
        return this;
    }

    private AnimationBuilder(List<Item> stacks) {
        this.stacks = stacks;
    }

    public static AnimationBuilder of(List<Item> stacks) {
        return new AnimationBuilder(stacks);
    }

    public List<Item> getStacks() {
        return this.stacks;
    }
}

