/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.simpleinventories.builder.BuilderUtils;
import io.github.pronze.lib.simpleinventories.builder.CategoryBuilder;
import io.github.pronze.lib.simpleinventories.builder.ItemInfoBuilder;
import io.github.pronze.lib.simpleinventories.builder.LocalOptionsBuilder;
import io.github.pronze.lib.simpleinventories.builder.QueueBuilder;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.events.OnTradeEvent;
import io.github.pronze.lib.simpleinventories.events.PostClickEvent;
import io.github.pronze.lib.simpleinventories.events.PreClickEvent;
import io.github.pronze.lib.simpleinventories.events.SubInventoryCloseEvent;
import io.github.pronze.lib.simpleinventories.events.SubInventoryOpenEvent;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.inventory.SubInventoryLike;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import java.util.List;
import java.util.function.Consumer;

public class InventorySetBuilder
extends CategoryBuilder {
    private final InventorySet inventorySet;

    @Override
    public SubInventory getSubInventory() {
        if (this.subInventory == null) {
            this.subInventory = this.inventorySet.getMainSubInventory();
        }
        return this.subInventory;
    }

    public InventorySetBuilder variableToProperty(String variable, String property) {
        this.inventorySet.getVariableToPropertyMap().put(variable, property);
        return this;
    }

    public InventorySetBuilder genericShop(boolean genericShop) {
        this.inventorySet.setGenericShop(genericShop);
        return this;
    }

    public InventorySetBuilder genericShopPriceTypeRequired(boolean genericShop) {
        this.inventorySet.setGenericShopPriceTypeRequired(genericShop);
        return this;
    }

    public InventorySetBuilder animationsEnabled(boolean animationsEnabled) {
        this.inventorySet.setAnimationsEnabled(animationsEnabled);
        return this;
    }

    public InventorySetBuilder allowAccessToConsole(boolean allowAccessToConsole) {
        this.inventorySet.setAllowAccessToConsole(allowAccessToConsole);
        return this;
    }

    public InventorySetBuilder allowBungeecordPlayerSending(boolean allowBungeecordPlayerSending) {
        this.inventorySet.setAllowBungeecordPlayerSending(allowBungeecordPlayerSending);
        return this;
    }

    public InventorySetBuilder define(String definition) {
        BuilderUtils.buildDefinition(this.inventorySet, definition);
        return this;
    }

    public InventorySetBuilder define(String placeholder, IPlaceholderParser placeholderParser) {
        this.inventorySet.registerPlaceholder(placeholder, placeholderParser);
        return this;
    }

    public InventorySetBuilder define(String placeholder, String value) {
        this.inventorySet.registerPlaceholder(placeholder, value);
        return this;
    }

    public InventorySetBuilder render(Consumer<ItemRenderEvent> consumer) {
        this.inventorySet.getEventManager().register(ItemRenderEvent.class, consumer);
        return this;
    }

    public InventorySetBuilder preClick(Consumer<PreClickEvent> consumer) {
        this.inventorySet.getEventManager().register(PreClickEvent.class, consumer);
        return this;
    }

    public InventorySetBuilder click(Consumer<PostClickEvent> consumer) {
        this.inventorySet.getEventManager().register(PostClickEvent.class, consumer);
        return this;
    }

    public InventorySetBuilder open(Consumer<SubInventoryOpenEvent> consumer) {
        this.inventorySet.getEventManager().register(SubInventoryOpenEvent.class, consumer);
        return this;
    }

    public InventorySetBuilder close(Consumer<SubInventoryCloseEvent> consumer) {
        this.inventorySet.getEventManager().register(SubInventoryCloseEvent.class, consumer);
        return this;
    }

    public InventorySetBuilder buy(Consumer<OnTradeEvent> consumer) {
        this.inventorySet.getEventManager().register(OnTradeEvent.class, consumer);
        return this;
    }

    @Override
    public InventorySetBuilder categoryOptions(Consumer<LocalOptionsBuilder> consumer) {
        return (InventorySetBuilder)super.categoryOptions(consumer);
    }

    @Override
    public InventorySetBuilder category(Object material) {
        return (InventorySetBuilder)super.category(material);
    }

    @Override
    public InventorySetBuilder category(Object material, Consumer<ItemInfoBuilder> consumer) {
        return (InventorySetBuilder)super.category(material, consumer);
    }

    @Override
    public InventorySetBuilder item(Object material) {
        return (InventorySetBuilder)super.item(material);
    }

    @Override
    public InventorySetBuilder item(Object material, Consumer<ItemInfoBuilder> consumer) {
        return (InventorySetBuilder)super.item(material, consumer);
    }

    @Override
    public InventorySetBuilder cosmetic() {
        return (InventorySetBuilder)super.cosmetic();
    }

    @Override
    public InventorySetBuilder cosmetic(Consumer<ItemInfoBuilder> consumer) {
        return (InventorySetBuilder)super.cosmetic(consumer);
    }

    @Override
    public InventorySetBuilder itemClone(String link) {
        return (InventorySetBuilder)super.itemClone(link);
    }

    @Override
    public InventorySetBuilder itemClone(String link, Consumer<ItemInfoBuilder> consumer) {
        return (InventorySetBuilder)super.itemClone(link, consumer);
    }

    @Override
    public InventorySetBuilder include(String include) {
        return (InventorySetBuilder)super.include(include);
    }

    @Override
    public InventorySetBuilder include(Include include) {
        return (InventorySetBuilder)super.include(include);
    }

    @Override
    public InventorySetBuilder hidden(String id, Consumer<CategoryBuilder> consumer) {
        return (InventorySetBuilder)super.hidden(id, consumer);
    }

    @Override
    public InventorySetBuilder hidden(String id) {
        return (InventorySetBuilder)super.hidden(id);
    }

    @Override
    public InventorySetBuilder insert(String link, Consumer<QueueBuilder> consumer) {
        return (InventorySetBuilder)super.insert(link, consumer);
    }

    @Override
    public InventorySetBuilder insert(String link, SubInventoryLike<?> prebuiltInventory) {
        return (InventorySetBuilder)super.insert(link, prebuiltInventory);
    }

    @Override
    public InventorySetBuilder insert(List<String> links, Consumer<QueueBuilder> consumer) {
        return (InventorySetBuilder)super.insert(links, consumer);
    }

    @Override
    public InventorySetBuilder insert(List<String> links, SubInventoryLike<?> prebuiltInventory) {
        return (InventorySetBuilder)super.insert(links, prebuiltInventory);
    }

    @Override
    public InventorySetBuilder call(Consumer<CategoryBuilder> consumer) {
        return (InventorySetBuilder)super.call(consumer);
    }

    public InventorySet getInventorySet() {
        return this.inventorySet;
    }

    private InventorySetBuilder(InventorySet inventorySet) {
        this.inventorySet = inventorySet;
    }

    public static InventorySetBuilder of(InventorySet inventorySet) {
        return new InventorySetBuilder(inventorySet);
    }
}

