/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.utils.ConsumerExecutor;
import io.github.pronze.lib.simpleinventories.builder.AnimationBuilder;
import io.github.pronze.lib.simpleinventories.builder.CategoryBuilder;
import io.github.pronze.lib.simpleinventories.builder.LocalOptionsBuilder;
import io.github.pronze.lib.simpleinventories.builder.QueueBuilder;
import io.github.pronze.lib.simpleinventories.events.ItemRenderEvent;
import io.github.pronze.lib.simpleinventories.events.OnTradeEvent;
import io.github.pronze.lib.simpleinventories.events.PostClickEvent;
import io.github.pronze.lib.simpleinventories.events.PreClickEvent;
import io.github.pronze.lib.simpleinventories.inventory.Clone;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Include;
import io.github.pronze.lib.simpleinventories.inventory.InventoryLink;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Price;
import io.github.pronze.lib.simpleinventories.inventory.Property;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.inventory.SubInventoryLike;
import io.github.pronze.lib.simpleinventories.inventory.Times;
import io.github.pronze.lib.simpleinventories.operations.OperationParser;
import io.github.pronze.lib.simpleinventories.operations.conditions.Condition;
import io.github.pronze.lib.simpleinventories.utils.BreakType;
import io.github.pronze.lib.simpleinventories.utils.CloneMethod;
import io.github.pronze.lib.simpleinventories.utils.Column;
import io.github.pronze.lib.simpleinventories.utils.TimesFlags;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ItemInfoBuilder
extends CategoryBuilder {
    private final GenericItemInfo itemInfo;
    private ItemBuilder builder;
    public static final Pattern PRICE_PATTERN = Pattern.compile("(?<price>\\d+)(\\s+of\\s+|\\s+)(?<currency>[a-zA-Z0-9]+)?");

    public ItemInfoBuilder stack(Consumer<ItemBuilder> consumer) {
        ConsumerExecutor.execute(consumer, this.getStack());
        this.processItemBuilderIfOpened();
        return this;
    }

    public ItemBuilder getStack() {
        if (this.builder == null) {
            this.builder = this.itemInfo.getItem() != null ? this.itemInfo.getItem().builder() : ItemFactory.builder();
        }
        return this.builder;
    }

    public void processItemBuilderIfOpened() {
        if (this.builder != null) {
            this.builder.build().ifPresent(this.itemInfo::setItem);
            this.builder = null;
        }
    }

    public ItemInfoBuilder price(String price) {
        Matcher matcher = PRICE_PATTERN.matcher(price);
        while (matcher.find()) {
            Price price1 = new Price();
            price1.setAmount(Integer.parseInt(matcher.group("price")));
            price1.setCurrency(matcher.group("currency"));
            this.itemInfo.getPrices().add(price1);
        }
        return this;
    }

    public ItemInfoBuilder price(Price price) {
        this.itemInfo.getPrices().add(price);
        return this;
    }

    public ItemInfoBuilder price(List<Object> prices) {
        prices.forEach(o -> {
            if (o instanceof Price) {
                this.price((Price)o);
            } else {
                this.price(o.toString());
            }
        });
        return this;
    }

    @Deprecated
    public ItemInfoBuilder priceType(String priceType) {
        this.itemInfo.setDefaultCurrency(priceType);
        return this;
    }

    public ItemInfoBuilder property(String name) {
        this.itemInfo.getProperties().add(new Property(this.itemInfo.getFormat(), name));
        return this;
    }

    public ItemInfoBuilder property(String name, Map<String, Object> map) {
        try {
            return this.property(name, BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return this;
        }
    }

    public ItemInfoBuilder property(String name, ConfigurationNode configurationNode) {
        this.itemInfo.getProperties().add(new Property(this.itemInfo.getFormat(), name, configurationNode));
        return this;
    }

    public ItemInfoBuilder property(Map<String, Object> map) {
        try {
            return this.property(BasicConfigurationNode.root().set(map));
        }
        catch (SerializationException e) {
            e.printStackTrace();
            return this;
        }
    }

    public ItemInfoBuilder property(ConfigurationNode configurationNode) {
        return this.property(configurationNode.node("name").getString(), configurationNode);
    }

    public ItemInfoBuilder disabled(boolean disabled) {
        this.itemInfo.setDisabled(() -> disabled);
        return this;
    }

    public ItemInfoBuilder disabled(String condition) {
        Condition condition_obj = OperationParser.getFinalCondition(this.itemInfo.getFormat(), condition);
        this.itemInfo.getEventManager().register(ItemRenderEvent.class, itemRenderEvent -> itemRenderEvent.getItem().setDisabled(condition_obj.process(itemRenderEvent.getPlayer(), itemRenderEvent.getItem())));
        return this;
    }

    public ItemInfoBuilder disabled(Predicate<PlayerItemInfo> predicate) {
        this.itemInfo.getEventManager().register(ItemRenderEvent.class, itemRenderEvent -> itemRenderEvent.getItem().setDisabled(ConsumerExecutor.execute(predicate, itemRenderEvent.getItem())));
        return this;
    }

    public ItemInfoBuilder id(String id) {
        this.itemInfo.setId(id);
        return this;
    }

    public ItemInfoBuilder absolute(int absolute) {
        this.itemInfo.getRequestedPosition().setAbsolute(() -> absolute);
        return this;
    }

    public ItemInfoBuilder clone(String link) {
        if (this.itemInfo.getRequestedClone() == null) {
            this.itemInfo.setRequestedClone(new Clone());
        }
        this.itemInfo.getRequestedClone().setCloneLink(link);
        return this;
    }

    public ItemInfoBuilder cloneMethod(String cloneMethod) {
        try {
            this.cloneMethod(CloneMethod.valueOf(cloneMethod.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public ItemInfoBuilder cloneMethod(CloneMethod cloneMethod) {
        if (this.itemInfo.getRequestedClone() == null) {
            this.itemInfo.setRequestedClone(new Clone());
        }
        this.itemInfo.getRequestedClone().setCloneMethod(cloneMethod);
        return this;
    }

    public ItemInfoBuilder column(int number) {
        this.itemInfo.getRequestedPosition().setColumn(integer -> number);
        return this;
    }

    public ItemInfoBuilder column(String colName) {
        try {
            this.column(Column.valueOf(colName.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public ItemInfoBuilder column(Column column) {
        this.itemInfo.getRequestedPosition().setColumn(column::convert);
        return this;
    }

    public ItemInfoBuilder linebreak(String linebreak) {
        try {
            this.linebreak(BreakType.valueOf(linebreak.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public ItemInfoBuilder linebreak(BreakType linebreak) {
        this.itemInfo.getRequestedPosition().setLinebreak(() -> linebreak);
        return this;
    }

    public ItemInfoBuilder pagebreak(String pagebreak) {
        try {
            this.pagebreak(BreakType.valueOf(pagebreak.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public ItemInfoBuilder pagebreak(BreakType pagebreak) {
        this.itemInfo.getRequestedPosition().setPagebreak(() -> pagebreak);
        return this;
    }

    public ItemInfoBuilder row(int row) {
        this.itemInfo.getRequestedPosition().setRow(() -> row);
        return this;
    }

    public ItemInfoBuilder skip(int skip) {
        this.itemInfo.getRequestedPosition().setSkip(() -> skip);
        return this;
    }

    public ItemInfoBuilder times(int times) {
        if (this.itemInfo.getRequestedTimes() == null) {
            this.itemInfo.setRequestedTimes(new Times());
        }
        this.itemInfo.getRequestedTimes().setRepeat(times);
        return this;
    }

    public ItemInfoBuilder timesMethods(String method) {
        try {
            this.timesMethods(TimesFlags.valueOf(method.toUpperCase()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    public ItemInfoBuilder timesMethods(TimesFlags method) {
        if (this.itemInfo.getRequestedTimes() == null) {
            this.itemInfo.setRequestedTimes(new Times());
        }
        this.itemInfo.getRequestedTimes().getFlags().add(method);
        return this;
    }

    public ItemInfoBuilder timesMethods(List<Object> methods) {
        methods.forEach(o -> {
            if (o instanceof TimesFlags) {
                this.timesMethods((TimesFlags)((Object)((Object)o)));
            } else {
                this.timesMethods(o.toString());
            }
        });
        return this;
    }

    public ItemInfoBuilder visible(boolean visible) {
        this.itemInfo.setVisible(() -> visible);
        return this;
    }

    public ItemInfoBuilder visible(String condition) {
        Condition condition_obj = OperationParser.getFinalCondition(this.itemInfo.getFormat(), condition);
        this.itemInfo.getEventManager().register(ItemRenderEvent.class, itemRenderEvent -> itemRenderEvent.getItem().setVisible(condition_obj.process(itemRenderEvent.getPlayer(), itemRenderEvent.getItem())));
        return this;
    }

    public ItemInfoBuilder visible(Predicate<PlayerItemInfo> predicate) {
        this.itemInfo.getEventManager().register(ItemRenderEvent.class, itemRenderEvent -> itemRenderEvent.getItem().setVisible(ConsumerExecutor.execute(predicate, itemRenderEvent.getItem())));
        return this;
    }

    @Deprecated
    public ItemInfoBuilder write(boolean write) {
        this.itemInfo.setWritten(() -> write);
        return this;
    }

    public AnimationBuilder getAnimation() {
        return AnimationBuilder.of(this.itemInfo.getAnimation());
    }

    public ItemInfoBuilder animation(Consumer<AnimationBuilder> consumer) {
        ConsumerExecutor.execute(consumer, this.getAnimation());
        return this;
    }

    public ItemInfoBuilder execute(String command) {
        this.itemInfo.getExecutions().add(command);
        return this;
    }

    public ItemInfoBuilder execute(List<String> commands) {
        this.itemInfo.getExecutions().addAll(commands);
        return this;
    }

    public ItemInfoBuilder locate(String locate) {
        this.itemInfo.setLocate(InventoryLink.of(this.getFormat(), locate));
        return this;
    }

    public ItemInfoBuilder locate(InventorySet inventorySet) {
        this.itemInfo.setLocate(InventoryLink.of(inventorySet));
        return this;
    }

    public ItemInfoBuilder locate(SubInventory subInventory) {
        this.itemInfo.setLocate(InventoryLink.of(subInventory));
        return this;
    }

    public ItemInfoBuilder locate(InventorySet inventorySet, String locate) {
        this.itemInfo.setLocate(InventoryLink.of(inventorySet, locate));
        return this;
    }

    public ItemInfoBuilder render(Consumer<ItemRenderEvent> consumer) {
        this.itemInfo.getEventManager().register(ItemRenderEvent.class, consumer);
        return this;
    }

    public ItemInfoBuilder preClick(Consumer<PreClickEvent> consumer) {
        this.itemInfo.getEventManager().register(PreClickEvent.class, consumer);
        return this;
    }

    public ItemInfoBuilder click(Consumer<PostClickEvent> consumer) {
        this.itemInfo.getEventManager().register(PostClickEvent.class, consumer);
        return this;
    }

    public ItemInfoBuilder buy(Consumer<OnTradeEvent> consumer) {
        this.itemInfo.getEventManager().register(OnTradeEvent.class, consumer);
        return this;
    }

    public ItemInfoBuilder upgrade(Map<String, Object> map) {
        if (this.getFormat().getVariableToPropertyMap().containsKey("upgrade")) {
            String propertyName = this.getFormat().getVariableToPropertyMap().get("upgrade");
            Property property = this.itemInfo.getProperties().stream().filter(property1 -> property1.getPropertyName().equals(propertyName)).findFirst().orElseGet(() -> {
                Property newProperty = new Property(this.getFormat(), propertyName, BasicConfigurationNode.root());
                this.itemInfo.getProperties().add(newProperty);
                return newProperty;
            });
            ConfigurationNode upgrades = property.getPropertyData();
            ConfigurationNode entities = upgrades.node("entities");
            try {
                entities.appendListNode().set(map);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        return this;
    }

    @Override
    public SubInventory getSubInventory() {
        if (this.subInventory == null) {
            if (!this.itemInfo.hasChildInventory()) {
                this.itemInfo.setChildInventory(new SubInventory(false, this.itemInfo, this.itemInfo.getFormat()));
            }
            this.subInventory = this.itemInfo.getChildInventory();
        }
        return this.subInventory;
    }

    @Override
    protected InventorySet getFormat() {
        return this.itemInfo.getFormat();
    }

    @Override
    public ItemInfoBuilder categoryOptions(Consumer<LocalOptionsBuilder> consumer) {
        return (ItemInfoBuilder)super.categoryOptions(consumer);
    }

    @Override
    public ItemInfoBuilder category(Object material) {
        return (ItemInfoBuilder)super.category(material);
    }

    @Override
    public ItemInfoBuilder category(Object material, Consumer<ItemInfoBuilder> consumer) {
        return (ItemInfoBuilder)super.category(material, consumer);
    }

    @Override
    public ItemInfoBuilder item(Object material) {
        return (ItemInfoBuilder)super.item(material);
    }

    @Override
    public ItemInfoBuilder item(Object material, Consumer<ItemInfoBuilder> consumer) {
        return (ItemInfoBuilder)super.item(material, consumer);
    }

    @Override
    public ItemInfoBuilder cosmetic() {
        return (ItemInfoBuilder)super.cosmetic();
    }

    @Override
    public ItemInfoBuilder cosmetic(Consumer<ItemInfoBuilder> consumer) {
        return (ItemInfoBuilder)super.cosmetic(consumer);
    }

    @Override
    public ItemInfoBuilder itemClone(String link) {
        return (ItemInfoBuilder)super.itemClone(link);
    }

    @Override
    public ItemInfoBuilder itemClone(String link, Consumer<ItemInfoBuilder> consumer) {
        return (ItemInfoBuilder)super.itemClone(link, consumer);
    }

    @Override
    public ItemInfoBuilder include(String include) {
        return (ItemInfoBuilder)super.include(include);
    }

    @Override
    public ItemInfoBuilder include(Include include) {
        return (ItemInfoBuilder)super.include(include);
    }

    @Override
    public ItemInfoBuilder hidden(String id, Consumer<CategoryBuilder> consumer) {
        return (ItemInfoBuilder)super.hidden(id, consumer);
    }

    @Override
    public ItemInfoBuilder hidden(String id) {
        return (ItemInfoBuilder)super.hidden(id);
    }

    @Override
    public ItemInfoBuilder insert(String link, Consumer<QueueBuilder> consumer) {
        return (ItemInfoBuilder)super.insert(link, consumer);
    }

    @Override
    public ItemInfoBuilder insert(String link, SubInventoryLike<?> prebuiltInventory) {
        return (ItemInfoBuilder)super.insert(link, prebuiltInventory);
    }

    @Override
    public ItemInfoBuilder insert(List<String> links, Consumer<QueueBuilder> consumer) {
        return (ItemInfoBuilder)super.insert(links, consumer);
    }

    @Override
    public ItemInfoBuilder insert(List<String> links, SubInventoryLike<?> prebuiltInventory) {
        return (ItemInfoBuilder)super.insert(links, prebuiltInventory);
    }

    public GenericItemInfo getItemInfo() {
        return this.itemInfo;
    }

    public ItemBuilder getBuilder() {
        return this.builder;
    }

    private ItemInfoBuilder(GenericItemInfo itemInfo) {
        this.itemInfo = itemInfo;
    }

    public static ItemInfoBuilder of(GenericItemInfo itemInfo) {
        return new ItemInfoBuilder(itemInfo);
    }
}

