/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.builder;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.item.builder.ItemBuilder;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.simpleinventories.inventory.LocalOptions;
import java.util.function.Consumer;

public class LocalOptionsBuilder {
    private final LocalOptions localOptions;
    public static final int ROWS = 4;
    public static final int ITEMS_ON_ROW = 9;
    public static final int RENDER_ACTUAL_ROWS = 6;
    public static final int RENDER_OFFSET = 9;
    public static final int RENDER_HEADER_START = 0;
    public static final int RENDER_FOOTER_START = 45;

    public LocalOptionsBuilder backItem(Consumer<ItemBuilder> consumer) {
        this.localOptions.setBackItem(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageBackItem(Consumer<ItemBuilder> consumer) {
        this.localOptions.setPageBackItem(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(Consumer<ItemBuilder> consumer) {
        this.localOptions.setPageForwardItem(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(Consumer<ItemBuilder> consumer) {
        this.localOptions.setCosmeticItem(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(Consumer<ItemBuilder> consumer) {
        this.localOptions.setEmptySlotItem(ItemFactory.build(consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder backItem(Object stack) {
        this.localOptions.setBackItem(ItemFactory.build(stack).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageBackItem(Object stack) {
        this.localOptions.setPageBackItem(ItemFactory.build(stack).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(Object stack) {
        this.localOptions.setPageForwardItem(ItemFactory.build(stack).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(Object stack) {
        this.localOptions.setCosmeticItem(ItemFactory.build(stack).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(Object stack) {
        this.localOptions.setEmptySlotItem(ItemFactory.build(stack).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder backItem(Object stack, Consumer<ItemBuilder> consumer) {
        this.localOptions.setBackItem(ItemFactory.build(stack, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageBackItem(Object stack, Consumer<ItemBuilder> consumer) {
        this.localOptions.setPageBackItem(ItemFactory.build(stack, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder pageForwardItem(Object stack, Consumer<ItemBuilder> consumer) {
        this.localOptions.setPageForwardItem(ItemFactory.build(stack, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder cosmeticItem(Object stack, Consumer<ItemBuilder> consumer) {
        this.localOptions.setCosmeticItem(ItemFactory.build(stack, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder emptySlotItem(Object stack, Consumer<ItemBuilder> consumer) {
        this.localOptions.setEmptySlotItem(ItemFactory.build(stack, consumer).orElse(ItemFactory.getAir()));
        return this;
    }

    public LocalOptionsBuilder rows(int rows) {
        this.localOptions.setRows(rows);
        return this;
    }

    public LocalOptionsBuilder itemsOnRow(int itemsOnRow) {
        this.localOptions.setItemsOnRow(itemsOnRow);
        return this;
    }

    public LocalOptionsBuilder renderActualRows(int renderActualItems) {
        this.localOptions.setRenderActualRows(renderActualItems);
        return this;
    }

    public LocalOptionsBuilder renderOffset(int renderOffset) {
        this.localOptions.setRenderOffset(renderOffset);
        return this;
    }

    public LocalOptionsBuilder renderHeaderStart(int renderHeaderStart) {
        this.localOptions.setRenderHeaderStart(renderHeaderStart);
        return this;
    }

    public LocalOptionsBuilder renderFooterStart(int renderFooterStart) {
        this.localOptions.setRenderFooterStart(renderFooterStart);
        return this;
    }

    public LocalOptionsBuilder inventoryType(String inventoryType) {
        this.localOptions.setInventoryType(inventoryType);
        return this;
    }

    public LocalOptionsBuilder showPageNumber(boolean showPageNumber) {
        this.localOptions.setShowPageNumber(showPageNumber);
        return this;
    }

    public LocalOptionsBuilder prefix(String prefix) {
        this.localOptions.setPrefix(AdventureHelper.toComponent(prefix));
        return this;
    }

    public LocalOptionsBuilder prefix(Component prefix) {
        this.localOptions.setPrefix(prefix);
        return this;
    }

    private LocalOptionsBuilder(LocalOptions localOptions) {
        this.localOptions = localOptions;
    }

    public static LocalOptionsBuilder of(LocalOptions localOptions) {
        return new LocalOptionsBuilder(localOptions);
    }

    public LocalOptions getLocalOptions() {
        return this.localOptions;
    }
}

