/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.bukkit.action;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ClickType;
import io.github.pronze.lib.simpleinventories.action.ClickActionHandler;
import io.github.pronze.lib.simpleinventories.bukkit.SimpleInventoriesBukkit;
import io.github.pronze.lib.simpleinventories.bukkit.holder.AbstractHolder;
import io.github.pronze.lib.simpleinventories.bukkit.render.BukkitInventoryRenderer;
import io.github.pronze.lib.simpleinventories.bukkit.utils.InventoryUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class BukkitClickActionHandler
extends ClickActionHandler
implements Listener {
    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.isCancelled() || !(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory primaryInventory = event.getInventory();
        InventoryHolder possibleHolder = primaryInventory.getHolder();
        if (possibleHolder instanceof AbstractHolder) {
            Player player = (Player)event.getWhoClicked();
            BukkitInventoryRenderer inventoryRenderer = ((AbstractHolder)possibleHolder).getInventoryRenderer();
            if (!inventoryRenderer.getPlayer().equals(PlayerMapper.wrapPlayer(player))) {
                event.setCancelled(true);
                return;
            }
            Inventory inventory = InventoryUtils.getInventory(event.getView(), event.getRawSlot());
            if (!primaryInventory.equals(inventory)) {
                if (event.getClick().isShiftClick() || event.getClick().isKeyboardClick() || event.getClick().isCreativeAction()) {
                    event.setCancelled(true);
                }
                return;
            }
            event.setCancelled(true);
            this.handleAction(inventoryRenderer, event.getSlot(), ClickType.convert(event.getClick().name()));
        }
    }

    @Override
    protected void dispatchPlayerCommand(PlayerWrapper playerWrapper, String command) {
        playerWrapper.as(Player.class).performCommand(command);
    }

    @Override
    protected void dispatchConsoleCommand(String command) {
        Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
    }

    @Override
    protected void movePlayerOnProxy(PlayerWrapper playerWrapper, String server) {
        if (!Bukkit.getMessenger().getOutgoingChannels(SimpleInventoriesBukkit.getPlugin()).contains("BungeeCord")) {
            Bukkit.getMessenger().registerOutgoingPluginChannel(SimpleInventoriesBukkit.getPlugin(), "BungeeCord");
        }
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(server);
        playerWrapper.as(Player.class).sendPluginMessage(SimpleInventoriesBukkit.getPlugin(), "BungeeCord", out.toByteArray());
    }
}

