/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.bukkit.placeholders;

import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.placeholders.IPlaceholderParser;
import org.bukkit.entity.Player;

public class PlayerPlaceholderParser
implements IPlaceholderParser {
    @Override
    public String processPlaceholder(String key, PlayerWrapper playerWrapper, PlayerItemInfo item, String[] arguments) {
        Player player = playerWrapper.as(Player.class);
        if (arguments.length >= 1) {
            switch (arguments[0]) {
                case "exp": 
                case "xp": {
                    return Float.toString(player.getExp());
                }
                case "level": {
                    return Integer.toString(player.getLevel());
                }
                case "displayName": {
                    return player.getDisplayName();
                }
                case "tabName": {
                    return player.getPlayerListName();
                }
                case "health": {
                    return Double.toString(player.getHealth());
                }
                case "maxhealth": {
                    return Double.toString(player.getMaxHealth());
                }
                case "isdead": 
                case "dead": {
                    return Boolean.toString(player.isDead());
                }
                case "isalive": 
                case "alive": {
                    return Boolean.toString(!player.isDead());
                }
                case "food": {
                    return Double.toString(player.getFoodLevel());
                }
                case "firsttime": {
                    return Long.toString(player.getFirstPlayed());
                }
                case "lasttime": {
                    return Long.toString(player.getLastPlayed());
                }
                case "playertime": {
                    return Long.toString(player.getPlayerTime());
                }
                case "gamemode": {
                    return player.getGameMode().name();
                }
            }
        }
        return player.getName();
    }
}

