/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.bukkit.render;

import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.Tasker;
import io.github.pronze.lib.screaminglib.tasker.TaskerTime;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import io.github.pronze.lib.simpleinventories.bukkit.holder.AbstractHolder;
import io.github.pronze.lib.simpleinventories.bukkit.holder.StandardInventoryHolder;
import io.github.pronze.lib.simpleinventories.inventory.LocalOptions;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import io.github.pronze.lib.simpleinventories.render.InventoryRenderer;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;

public class BukkitInventoryRenderer
extends InventoryRenderer {
    private AbstractHolder inventoryHolder;
    private static final List<String> SIZEABLE_CONTAINERS = List.of("CHEST", "ENDER_CHEST", "SHULKER_BOX", "BARREL");

    public BukkitInventoryRenderer(PlayerWrapper player, SubInventory subInventory, int page) {
        super(player, subInventory, page);
    }

    @Override
    protected void renderOnPlatform() {
        LocalOptions options = this.subInventory.getLocalOptions();
        if (this.inventoryHolder != null && this.inventoryHolder.getInventory().getSize() == options.getRenderActualRows() * options.getItemsOnRow() && (this.inventoryHolder.getInventory().getType().name().equalsIgnoreCase(options.getInventoryType()) || SIZEABLE_CONTAINERS.contains(options.getInventoryType().toUpperCase()) && SIZEABLE_CONTAINERS.contains(this.inventoryHolder.getInventory().getType().name()))) {
            this.inventoryHolder.getInventory().clear();
        } else {
            this.inventoryHolder = new StandardInventoryHolder();
        }
        Inventory inventory = SIZEABLE_CONTAINERS.contains(options.getInventoryType().toUpperCase()) ? Bukkit.createInventory((InventoryHolder)this.inventoryHolder, (int)(options.getRenderActualRows() * options.getItemsOnRow()), (String)AdventureHelper.toLegacy(this.getTitle())) : Bukkit.createInventory((InventoryHolder)this.inventoryHolder, (InventoryType)InventoryType.valueOf((String)options.getInventoryType().toUpperCase()), (String)AdventureHelper.toLegacy(this.getTitle()));
        this.inventoryHolder.setInventoryRenderer(this);
        this.inventoryHolder.setInventory(inventory);
        this.inventoryHolder.setSubInventory(this.subInventory);
        Item emptyItem = options.getEmptySlotItem();
        for (int i = 0; i < inventory.getSize(); ++i) {
            inventory.setItem(i, emptyItem.as(ItemStack.class));
        }
        this.itemStacksInInventory.forEach((position, item) -> {
            if (position < inventory.getSize()) {
                ItemStack asStack = item.as(ItemStack.class);
                if (!item.getMaterial().isAir()) {
                    inventory.setItem(position.intValue(), asStack);
                }
            }
        });
        this.player.asOptional(Player.class).ifPresent(p -> p.openInventory(inventory));
        if (!this.animations.isEmpty()) {
            this.animator = Tasker.build(() -> this.animations.forEach((position, items) -> inventory.setItem(position.intValue(), ((Item)items.get(this.nextAnimationPosition % items.size())).as(ItemStack.class)))).delay(1L, TaskerTime.TICKS).repeat(20L, TaskerTime.TICKS).start();
        }
    }

    @Override
    public boolean isOpened() {
        return this.player.as(Player.class).getOpenInventory().getTopInventory().getHolder() == this.inventoryHolder;
    }

    @Override
    public void close() {
        super.close();
        this.player.closeInventory();
    }
}

