/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.events;

import io.github.pronze.lib.screaminglib.event.SCancellableEvent;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.utils.ClickType;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.Price;
import io.github.pronze.lib.simpleinventories.inventory.Property;
import java.util.List;

public class OnTradeEvent
implements SCancellableEvent {
    private final PlayerWrapper player;
    private final List<Price> prices;
    private final Item stack;
    private final PlayerItemInfo item;
    private final ClickType clickType;
    private boolean cancelled;

    public InventorySet getFormat() {
        return this.item.getFormat();
    }

    @Deprecated
    public int getPrice() {
        return this.prices.get(0).getAmount();
    }

    @Deprecated
    public String getType() {
        return this.prices.get(0).getCurrency();
    }

    public boolean hasPlayerInInventory() {
        return this.hasPlayerInInventory(this.stack);
    }

    public boolean hasPlayerInInventory(Item item) {
        return this.player.getPlayerInventory().containsAtLeast(item, item.getAmount());
    }

    public List<Item> sellStack() {
        return this.sellStack(this.stack);
    }

    public List<Item> sellStack(Item item) {
        return this.player.getPlayerInventory().removeItem(item);
    }

    public List<Item> buyStack() {
        return this.buyStack(this.stack);
    }

    public List<Item> buyStack(Item item) {
        return this.player.getPlayerInventory().addItem(item);
    }

    public List<Property> getProperties() {
        return this.item.getProperties();
    }

    public boolean hasProperties() {
        return this.item.hasProperties();
    }

    public PlayerWrapper getPlayer() {
        return this.player;
    }

    public List<Price> getPrices() {
        return this.prices;
    }

    public Item getStack() {
        return this.stack;
    }

    public PlayerItemInfo getItem() {
        return this.item;
    }

    public ClickType getClickType() {
        return this.clickType;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OnTradeEvent)) {
            return false;
        }
        OnTradeEvent other = (OnTradeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCancelled() != other.isCancelled()) {
            return false;
        }
        PlayerWrapper this$player = this.getPlayer();
        PlayerWrapper other$player = other.getPlayer();
        if (this$player == null ? other$player != null : !this$player.equals(other$player)) {
            return false;
        }
        List<Price> this$prices = this.getPrices();
        List<Price> other$prices = other.getPrices();
        if (this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices)) {
            return false;
        }
        Item this$stack = this.getStack();
        Item other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        PlayerItemInfo this$item = this.getItem();
        PlayerItemInfo other$item = other.getItem();
        if (this$item == null ? other$item != null : !((Object)this$item).equals(other$item)) {
            return false;
        }
        ClickType this$clickType = this.getClickType();
        ClickType other$clickType = other.getClickType();
        return !(this$clickType == null ? other$clickType != null : !((Object)((Object)this$clickType)).equals((Object)other$clickType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OnTradeEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCancelled() ? 79 : 97);
        PlayerWrapper $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        List<Price> $prices = this.getPrices();
        result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
        Item $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        PlayerItemInfo $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
        ClickType $clickType = this.getClickType();
        result = result * 59 + ($clickType == null ? 43 : ((Object)((Object)$clickType)).hashCode());
        return result;
    }

    public String toString() {
        return "OnTradeEvent(player=" + this.getPlayer() + ", prices=" + this.getPrices() + ", stack=" + this.getStack() + ", item=" + this.getItem() + ", clickType=" + this.getClickType() + ", cancelled=" + this.isCancelled() + ")";
    }

    public OnTradeEvent(PlayerWrapper player, List<Price> prices, Item stack, PlayerItemInfo item, ClickType clickType) {
        this.player = player;
        this.prices = prices;
        this.stack = stack;
        this.item = item;
        this.clickType = clickType;
    }
}

