/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class InventoryLink {
    private InventorySet inventorySet;
    private String link;
    private SubInventory subInventory;

    @NotNull
    public static InventoryLink of(@NotNull InventorySet inventorySet, @NotNull String link) {
        InventoryLink locate = new InventoryLink();
        locate.inventorySet = inventorySet;
        locate.link = link;
        return locate;
    }

    @NotNull
    public static InventoryLink of(@NotNull SubInventory subInventory) {
        InventoryLink locate = new InventoryLink();
        locate.subInventory = subInventory;
        return locate;
    }

    @NotNull
    public static InventoryLink of(@NotNull InventorySet inventorySet) {
        return InventoryLink.of(inventorySet.getMainSubInventory());
    }

    public Optional<SubInventory> resolve() {
        if (this.subInventory != null) {
            return Optional.of(this.subInventory);
        }
        return this.inventorySet.resolveCategoryLink(this.link);
    }

    public InventorySet getInventorySet() {
        return this.inventorySet;
    }

    public String getLink() {
        return this.link;
    }

    public SubInventory getSubInventory() {
        return this.subInventory;
    }

    public void setInventorySet(InventorySet inventorySet) {
        this.inventorySet = inventorySet;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setSubInventory(SubInventory subInventory) {
        this.subInventory = subInventory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InventoryLink)) {
            return false;
        }
        InventoryLink other = (InventoryLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventorySet this$inventorySet = this.getInventorySet();
        InventorySet other$inventorySet = other.getInventorySet();
        if (this$inventorySet == null ? other$inventorySet != null : !((Object)this$inventorySet).equals(other$inventorySet)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        SubInventory this$subInventory = this.getSubInventory();
        SubInventory other$subInventory = other.getSubInventory();
        return !(this$subInventory == null ? other$subInventory != null : !((Object)this$subInventory).equals(other$subInventory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InventoryLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventorySet $inventorySet = this.getInventorySet();
        result = result * 59 + ($inventorySet == null ? 43 : ((Object)$inventorySet).hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        SubInventory $subInventory = this.getSubInventory();
        result = result * 59 + ($subInventory == null ? 43 : ((Object)$subInventory).hashCode());
        return result;
    }

    public String toString() {
        return "InventoryLink(link=" + this.getLink() + ", subInventory=" + this.getSubInventory() + ")";
    }

    private InventoryLink() {
    }
}

