/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.item.builder.ItemFactory;
import io.github.pronze.lib.screaminglib.utils.AdventureHelper;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public class LocalOptions
implements Cloneable {
    public static final int ROWS = 4;
    public static final int ITEMS_ON_ROW = 9;
    public static final int RENDER_ACTUAL_ROWS = 6;
    public static final int RENDER_OFFSET = 9;
    public static final int RENDER_HEADER_START = 0;
    public static final int RENDER_FOOTER_START = 45;
    public static final boolean SHOW_PAGE_NUMBER = true;
    public static final String INVENTORY_TYPE = "CHEST";
    public static final Component PREFIX = Component.text("Inventory");
    public static final Item BACK_ITEM = ItemFactory.build("BARRIER").orElse(ItemFactory.getAir());
    public static final Item PAGE_BACK_ITEM = ItemFactory.build("ARROW").orElse(ItemFactory.getAir());
    public static final Item PAGE_FORWARD_ITEM = ItemFactory.build("ARROW").orElse(ItemFactory.getAir());
    public static final Item COSMETIC_ITEM = ItemFactory.getAir();
    public static final Item EMPTY_SLOT_ITEM = ItemFactory.getAir();
    @Nullable
    private LocalOptions parent;
    @Nullable
    private Item backItem;
    @Nullable
    private Item pageBackItem;
    @Nullable
    private Item pageForwardItem;
    @Nullable
    private Item cosmeticItem;
    @Nullable
    private Item emptySlotItem;
    @Nullable
    private Boolean showPageNumber;
    @Nullable
    private Component prefix;
    @Nullable
    private String inventoryType;
    @Nullable
    private Integer rows;
    @Nullable
    private Integer itemsOnRow;
    @Nullable
    private Integer renderActualRows;
    @Nullable
    private Integer renderOffset;
    @Nullable
    private Integer renderHeaderStart;
    @Nullable
    private Integer renderFooterStart;

    public Item getBackItem() {
        return Optional.ofNullable(this.backItem).orElseGet(this.parent != null ? this.parent::getBackItem : BACK_ITEM::clone);
    }

    public Item getPageBackItem() {
        return Optional.ofNullable(this.pageBackItem).orElseGet(this.parent != null ? this.parent::getPageBackItem : PAGE_BACK_ITEM::clone);
    }

    public Item getPageForwardItem() {
        return Optional.ofNullable(this.pageForwardItem).orElseGet(this.parent != null ? this.parent::getPageForwardItem : PAGE_FORWARD_ITEM::clone);
    }

    public Item getCosmeticItem() {
        return Optional.ofNullable(this.cosmeticItem).orElseGet(this.parent != null ? this.parent::getCosmeticItem : COSMETIC_ITEM::clone);
    }

    public Item getEmptySlotItem() {
        return Optional.ofNullable(this.emptySlotItem).orElseGet(this.parent != null ? this.parent::getEmptySlotItem : EMPTY_SLOT_ITEM::clone);
    }

    public boolean isShowPageNumber() {
        return Optional.ofNullable(this.showPageNumber).orElseGet(this.parent != null ? this.parent::isShowPageNumber : () -> true);
    }

    public Component getPrefix() {
        return Optional.ofNullable(this.prefix).orElseGet(this.parent != null ? this.parent::getPrefix : () -> PREFIX);
    }

    public String getInventoryType() {
        return Optional.ofNullable(this.inventoryType).orElseGet(this.parent != null ? this.parent::getInventoryType : () -> INVENTORY_TYPE);
    }

    public int getRows() {
        return Optional.ofNullable(this.rows).orElseGet(this.parent != null ? this.parent::getRows : () -> 4);
    }

    public int getItemsOnRow() {
        return Optional.ofNullable(this.itemsOnRow).orElseGet(this.parent != null ? this.parent::getItemsOnRow : () -> 9);
    }

    public int getRenderActualRows() {
        return Optional.ofNullable(this.renderActualRows).orElseGet(this.parent != null ? this.parent::getRenderActualRows : () -> 6);
    }

    public int getRenderOffset() {
        return Optional.ofNullable(this.renderOffset).orElseGet(this.parent != null ? this.parent::getRenderOffset : () -> 9);
    }

    public int getRenderHeaderStart() {
        return Optional.ofNullable(this.renderHeaderStart).orElseGet(this.parent != null ? this.parent::getRenderHeaderStart : () -> 0);
    }

    public int getRenderFooterStart() {
        return Optional.ofNullable(this.renderFooterStart).orElseGet(this.parent != null ? this.parent::getRenderFooterStart : () -> 45);
    }

    public int getItemsOnPage() {
        return this.getItemsOnRow() * this.getRows();
    }

    public LocalOptions clone() {
        LocalOptions options = new LocalOptions();
        options.backItem = this.backItem != null ? this.backItem.clone() : null;
        options.pageBackItem = this.pageBackItem != null ? this.pageBackItem.clone() : null;
        options.pageForwardItem = this.pageForwardItem != null ? this.pageForwardItem.clone() : null;
        options.cosmeticItem = this.cosmeticItem != null ? this.cosmeticItem.clone() : null;
        options.showPageNumber = this.showPageNumber;
        options.prefix = this.prefix;
        options.inventoryType = this.inventoryType;
        options.rows = this.rows;
        options.itemsOnRow = this.itemsOnRow;
        options.renderActualRows = this.renderActualRows;
        options.renderOffset = this.renderOffset;
        options.renderHeaderStart = this.renderHeaderStart;
        options.renderFooterStart = this.renderFooterStart;
        return options;
    }

    public void fromNode(ConfigurationNode configurationNode) {
        ConfigurationNode showPageNumber;
        ConfigurationNode prefix;
        ConfigurationNode inventoryType;
        ConfigurationNode itemsOnRow;
        ConfigurationNode renderFooterStart;
        ConfigurationNode renderHeaderStart;
        ConfigurationNode renderOffset;
        ConfigurationNode renderActualRows;
        ConfigurationNode rows;
        ConfigurationNode cosmeticItem;
        ConfigurationNode pageForwardItem;
        ConfigurationNode pageBackItem;
        ConfigurationNode backItem = configurationNode.node("backItem");
        if (!backItem.empty()) {
            this.backItem = ItemFactory.build(backItem).orElse(null);
        }
        if (!(pageBackItem = configurationNode.node("pageBackItem")).empty()) {
            this.pageBackItem = ItemFactory.build(pageBackItem).orElse(null);
        }
        if (!(pageForwardItem = configurationNode.node("pageForwardItem")).empty()) {
            this.pageForwardItem = ItemFactory.build(pageForwardItem).orElse(null);
        }
        if (!(cosmeticItem = configurationNode.node("cosmeticItem")).empty()) {
            this.cosmeticItem = ItemFactory.build(cosmeticItem).orElse(null);
        }
        if (!(rows = configurationNode.node("rows")).empty()) {
            try {
                this.rows = rows.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderActualRows = configurationNode.node("render_actual_rows")).empty()) {
            try {
                this.renderActualRows = renderActualRows.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderOffset = configurationNode.node("render_offset")).empty()) {
            try {
                this.renderOffset = renderOffset.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderHeaderStart = configurationNode.node("render_header_start")).empty()) {
            try {
                this.renderHeaderStart = renderHeaderStart.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(renderFooterStart = configurationNode.node("render_footer_start")).empty()) {
            try {
                this.renderFooterStart = renderFooterStart.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(itemsOnRow = configurationNode.node("items_on_row")).empty()) {
            try {
                this.itemsOnRow = itemsOnRow.get(Integer.class);
            }
            catch (SerializationException e) {
                e.printStackTrace();
            }
        }
        if (!(inventoryType = configurationNode.node("inventoryType")).empty()) {
            this.inventoryType = inventoryType.getString();
        }
        if (!(prefix = configurationNode.node("prefix")).empty()) {
            try {
                this.prefix = prefix.get(Component.class);
            }
            catch (SerializationException ignored) {
                try {
                    this.prefix = AdventureHelper.toComponent(prefix.getString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (!(showPageNumber = configurationNode.node("showPageNumber")).empty()) {
            this.showPageNumber = showPageNumber.getBoolean();
        }
    }

    @Nullable
    public Boolean getShowPageNumber() {
        return this.showPageNumber;
    }

    public void setBackItem(@Nullable Item backItem) {
        this.backItem = backItem;
    }

    public void setPageBackItem(@Nullable Item pageBackItem) {
        this.pageBackItem = pageBackItem;
    }

    public void setPageForwardItem(@Nullable Item pageForwardItem) {
        this.pageForwardItem = pageForwardItem;
    }

    public void setCosmeticItem(@Nullable Item cosmeticItem) {
        this.cosmeticItem = cosmeticItem;
    }

    public void setEmptySlotItem(@Nullable Item emptySlotItem) {
        this.emptySlotItem = emptySlotItem;
    }

    public void setShowPageNumber(@Nullable Boolean showPageNumber) {
        this.showPageNumber = showPageNumber;
    }

    public void setPrefix(@Nullable Component prefix) {
        this.prefix = prefix;
    }

    public void setInventoryType(@Nullable String inventoryType) {
        this.inventoryType = inventoryType;
    }

    public void setRows(@Nullable Integer rows) {
        this.rows = rows;
    }

    public void setItemsOnRow(@Nullable Integer itemsOnRow) {
        this.itemsOnRow = itemsOnRow;
    }

    public void setRenderActualRows(@Nullable Integer renderActualRows) {
        this.renderActualRows = renderActualRows;
    }

    public void setRenderOffset(@Nullable Integer renderOffset) {
        this.renderOffset = renderOffset;
    }

    public void setRenderHeaderStart(@Nullable Integer renderHeaderStart) {
        this.renderHeaderStart = renderHeaderStart;
    }

    public void setRenderFooterStart(@Nullable Integer renderFooterStart) {
        this.renderFooterStart = renderFooterStart;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalOptions)) {
            return false;
        }
        LocalOptions other = (LocalOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$showPageNumber = this.getShowPageNumber();
        Boolean other$showPageNumber = other.getShowPageNumber();
        if (this$showPageNumber == null ? other$showPageNumber != null : !((Object)this$showPageNumber).equals(other$showPageNumber)) {
            return false;
        }
        if (this.getRows() != other.getRows()) {
            return false;
        }
        if (this.getItemsOnRow() != other.getItemsOnRow()) {
            return false;
        }
        if (this.getRenderActualRows() != other.getRenderActualRows()) {
            return false;
        }
        if (this.getRenderOffset() != other.getRenderOffset()) {
            return false;
        }
        if (this.getRenderHeaderStart() != other.getRenderHeaderStart()) {
            return false;
        }
        if (this.getRenderFooterStart() != other.getRenderFooterStart()) {
            return false;
        }
        LocalOptions this$parent = this.getParent();
        LocalOptions other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Item this$backItem = this.getBackItem();
        Item other$backItem = other.getBackItem();
        if (this$backItem == null ? other$backItem != null : !this$backItem.equals(other$backItem)) {
            return false;
        }
        Item this$pageBackItem = this.getPageBackItem();
        Item other$pageBackItem = other.getPageBackItem();
        if (this$pageBackItem == null ? other$pageBackItem != null : !this$pageBackItem.equals(other$pageBackItem)) {
            return false;
        }
        Item this$pageForwardItem = this.getPageForwardItem();
        Item other$pageForwardItem = other.getPageForwardItem();
        if (this$pageForwardItem == null ? other$pageForwardItem != null : !this$pageForwardItem.equals(other$pageForwardItem)) {
            return false;
        }
        Item this$cosmeticItem = this.getCosmeticItem();
        Item other$cosmeticItem = other.getCosmeticItem();
        if (this$cosmeticItem == null ? other$cosmeticItem != null : !this$cosmeticItem.equals(other$cosmeticItem)) {
            return false;
        }
        Item this$emptySlotItem = this.getEmptySlotItem();
        Item other$emptySlotItem = other.getEmptySlotItem();
        if (this$emptySlotItem == null ? other$emptySlotItem != null : !this$emptySlotItem.equals(other$emptySlotItem)) {
            return false;
        }
        Component this$prefix = this.getPrefix();
        Component other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        String this$inventoryType = this.getInventoryType();
        String other$inventoryType = other.getInventoryType();
        return !(this$inventoryType == null ? other$inventoryType != null : !this$inventoryType.equals(other$inventoryType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $showPageNumber = this.getShowPageNumber();
        result = result * 59 + ($showPageNumber == null ? 43 : ((Object)$showPageNumber).hashCode());
        result = result * 59 + this.getRows();
        result = result * 59 + this.getItemsOnRow();
        result = result * 59 + this.getRenderActualRows();
        result = result * 59 + this.getRenderOffset();
        result = result * 59 + this.getRenderHeaderStart();
        result = result * 59 + this.getRenderFooterStart();
        LocalOptions $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Item $backItem = this.getBackItem();
        result = result * 59 + ($backItem == null ? 43 : $backItem.hashCode());
        Item $pageBackItem = this.getPageBackItem();
        result = result * 59 + ($pageBackItem == null ? 43 : $pageBackItem.hashCode());
        Item $pageForwardItem = this.getPageForwardItem();
        result = result * 59 + ($pageForwardItem == null ? 43 : $pageForwardItem.hashCode());
        Item $cosmeticItem = this.getCosmeticItem();
        result = result * 59 + ($cosmeticItem == null ? 43 : $cosmeticItem.hashCode());
        Item $emptySlotItem = this.getEmptySlotItem();
        result = result * 59 + ($emptySlotItem == null ? 43 : $emptySlotItem.hashCode());
        Component $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        String $inventoryType = this.getInventoryType();
        result = result * 59 + ($inventoryType == null ? 43 : $inventoryType.hashCode());
        return result;
    }

    public String toString() {
        return "LocalOptions(backItem=" + this.getBackItem() + ", pageBackItem=" + this.getPageBackItem() + ", pageForwardItem=" + this.getPageForwardItem() + ", cosmeticItem=" + this.getCosmeticItem() + ", emptySlotItem=" + this.getEmptySlotItem() + ", showPageNumber=" + this.getShowPageNumber() + ", prefix=" + this.getPrefix() + ", inventoryType=" + this.getInventoryType() + ", rows=" + this.getRows() + ", itemsOnRow=" + this.getItemsOnRow() + ", renderActualRows=" + this.getRenderActualRows() + ", renderOffset=" + this.getRenderOffset() + ", renderHeaderStart=" + this.getRenderHeaderStart() + ", renderFooterStart=" + this.getRenderFooterStart() + ")";
    }

    @Deprecated
    @Nullable
    public LocalOptions getParent() {
        return this.parent;
    }

    @Deprecated
    public void setParent(@Nullable LocalOptions parent) {
        this.parent = parent;
    }
}

