/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.simpleinventories.utils.BreakType;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nullable;

public class Position
implements Cloneable {
    @Nullable
    private Supplier<Integer> absolute;
    @Nullable
    private Supplier<Integer> row;
    @Nullable
    private Function<Integer, Integer> column;
    @Nullable
    private Supplier<Integer> skip;
    @Nullable
    private Supplier<BreakType> linebreak;
    @Nullable
    private Supplier<BreakType> pagebreak;

    public int calculateThatPosition(int nextPosition, int columns, int rows) {
        int itemsOnPage = columns * rows;
        if (this.pagebreak != null && this.pagebreak.get().isBreakingBefore()) {
            nextPosition += itemsOnPage - nextPosition % itemsOnPage;
        }
        if (this.linebreak != null && this.linebreak.get().isBreakingBefore()) {
            nextPosition += columns - nextPosition % columns;
        }
        if (this.row != null) {
            nextPosition -= nextPosition % itemsOnPage;
            nextPosition += (this.row.get() - 1) * columns + nextPosition % columns;
        }
        if (this.column != null) {
            nextPosition -= nextPosition % columns;
            nextPosition += this.column.apply(columns).intValue();
        }
        if (this.skip != null) {
            nextPosition += this.skip.get().intValue();
        }
        if (this.absolute != null) {
            nextPosition = this.absolute.get();
        }
        return nextPosition;
    }

    public int calculateNextPosition(int nextPosition, int columns, int rows) {
        boolean broken = false;
        if (this.linebreak != null && this.linebreak.get().isBreakingAfter()) {
            broken = true;
            nextPosition += columns - nextPosition % columns;
        }
        if (this.pagebreak != null && this.pagebreak.get().isBreakingAfter()) {
            int itemsOnPage = columns * rows;
            broken = true;
            nextPosition += itemsOnPage - nextPosition % itemsOnPage;
        }
        if (!broken) {
            ++nextPosition;
        }
        return nextPosition;
    }

    public Position clone() {
        Position position = new Position();
        position.absolute = this.absolute;
        position.row = this.row;
        position.column = this.column;
        position.skip = this.skip;
        position.linebreak = this.linebreak;
        position.pagebreak = this.pagebreak;
        return position;
    }

    @Nullable
    public Supplier<Integer> getAbsolute() {
        return this.absolute;
    }

    @Nullable
    public Supplier<Integer> getRow() {
        return this.row;
    }

    @Nullable
    public Function<Integer, Integer> getColumn() {
        return this.column;
    }

    @Nullable
    public Supplier<Integer> getSkip() {
        return this.skip;
    }

    @Nullable
    public Supplier<BreakType> getLinebreak() {
        return this.linebreak;
    }

    @Nullable
    public Supplier<BreakType> getPagebreak() {
        return this.pagebreak;
    }

    public void setRow(@Nullable Supplier<Integer> row) {
        this.row = row;
    }

    public void setColumn(@Nullable Function<Integer, Integer> column) {
        this.column = column;
    }

    public void setSkip(@Nullable Supplier<Integer> skip) {
        this.skip = skip;
    }

    public void setLinebreak(@Nullable Supplier<BreakType> linebreak) {
        this.linebreak = linebreak;
    }

    public void setPagebreak(@Nullable Supplier<BreakType> pagebreak) {
        this.pagebreak = pagebreak;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Position)) {
            return false;
        }
        Position other = (Position)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<Integer> this$absolute = this.getAbsolute();
        Supplier<Integer> other$absolute = other.getAbsolute();
        if (this$absolute == null ? other$absolute != null : !this$absolute.equals(other$absolute)) {
            return false;
        }
        Supplier<Integer> this$row = this.getRow();
        Supplier<Integer> other$row = other.getRow();
        if (this$row == null ? other$row != null : !this$row.equals(other$row)) {
            return false;
        }
        Function<Integer, Integer> this$column = this.getColumn();
        Function<Integer, Integer> other$column = other.getColumn();
        if (this$column == null ? other$column != null : !this$column.equals(other$column)) {
            return false;
        }
        Supplier<Integer> this$skip = this.getSkip();
        Supplier<Integer> other$skip = other.getSkip();
        if (this$skip == null ? other$skip != null : !this$skip.equals(other$skip)) {
            return false;
        }
        Supplier<BreakType> this$linebreak = this.getLinebreak();
        Supplier<BreakType> other$linebreak = other.getLinebreak();
        if (this$linebreak == null ? other$linebreak != null : !this$linebreak.equals(other$linebreak)) {
            return false;
        }
        Supplier<BreakType> this$pagebreak = this.getPagebreak();
        Supplier<BreakType> other$pagebreak = other.getPagebreak();
        return !(this$pagebreak == null ? other$pagebreak != null : !this$pagebreak.equals(other$pagebreak));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Position;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<Integer> $absolute = this.getAbsolute();
        result = result * 59 + ($absolute == null ? 43 : $absolute.hashCode());
        Supplier<Integer> $row = this.getRow();
        result = result * 59 + ($row == null ? 43 : $row.hashCode());
        Function<Integer, Integer> $column = this.getColumn();
        result = result * 59 + ($column == null ? 43 : $column.hashCode());
        Supplier<Integer> $skip = this.getSkip();
        result = result * 59 + ($skip == null ? 43 : $skip.hashCode());
        Supplier<BreakType> $linebreak = this.getLinebreak();
        result = result * 59 + ($linebreak == null ? 43 : $linebreak.hashCode());
        Supplier<BreakType> $pagebreak = this.getPagebreak();
        result = result * 59 + ($pagebreak == null ? 43 : $pagebreak.hashCode());
        return result;
    }

    public String toString() {
        return "Position(absolute=" + this.getAbsolute() + ", row=" + this.getRow() + ", column=" + this.getColumn() + ", skip=" + this.getSkip() + ", linebreak=" + this.getLinebreak() + ", pagebreak=" + this.getPagebreak() + ")";
    }

    @Deprecated
    public void setAbsolute(@Nullable Supplier<Integer> absolute) {
        this.absolute = absolute;
    }
}

