/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.inventory;

import io.github.pronze.lib.configurate.BasicConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import org.jetbrains.annotations.NotNull;

public class Property
implements Cloneable {
    @NotNull
    private InventorySet inventorySet;
    private String propertyName;
    private ConfigurationNode propertyData;

    public Property(@NotNull InventorySet inventorySet, String propertyName) {
        this(inventorySet, propertyName, BasicConfigurationNode.root());
    }

    public boolean hasName() {
        return this.propertyName != null;
    }

    public Property clone() {
        return new Property(this.inventorySet, this.propertyName, this.propertyData.copy());
    }

    @NotNull
    public InventorySet getInventorySet() {
        return this.inventorySet;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public ConfigurationNode getPropertyData() {
        return this.propertyData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Property)) {
            return false;
        }
        Property other = (Property)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventorySet this$inventorySet = this.getInventorySet();
        InventorySet other$inventorySet = other.getInventorySet();
        if (this$inventorySet == null ? other$inventorySet != null : !((Object)this$inventorySet).equals(other$inventorySet)) {
            return false;
        }
        String this$propertyName = this.getPropertyName();
        String other$propertyName = other.getPropertyName();
        if (this$propertyName == null ? other$propertyName != null : !this$propertyName.equals(other$propertyName)) {
            return false;
        }
        ConfigurationNode this$propertyData = this.getPropertyData();
        ConfigurationNode other$propertyData = other.getPropertyData();
        return !(this$propertyData == null ? other$propertyData != null : !this$propertyData.equals(other$propertyData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Property;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventorySet $inventorySet = this.getInventorySet();
        result = result * 59 + ($inventorySet == null ? 43 : ((Object)$inventorySet).hashCode());
        String $propertyName = this.getPropertyName();
        result = result * 59 + ($propertyName == null ? 43 : $propertyName.hashCode());
        ConfigurationNode $propertyData = this.getPropertyData();
        result = result * 59 + ($propertyData == null ? 43 : $propertyData.hashCode());
        return result;
    }

    public String toString() {
        return "Property(inventorySet=" + this.getInventorySet() + ", propertyName=" + this.getPropertyName() + ", propertyData=" + this.getPropertyData() + ")";
    }

    public Property(@NotNull InventorySet inventorySet, String propertyName, ConfigurationNode propertyData) {
        if (inventorySet == null) {
            throw new NullPointerException("inventorySet is marked non-null but is null");
        }
        this.inventorySet = inventorySet;
        this.propertyName = propertyName;
        this.propertyData = propertyData;
    }

    @Deprecated
    public void setInventorySet(@NotNull InventorySet inventorySet) {
        if (inventorySet == null) {
            throw new NullPointerException("inventorySet is marked non-null but is null");
        }
        this.inventorySet = inventorySet;
    }

    @Deprecated
    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @Deprecated
    public void setPropertyData(ConfigurationNode propertyData) {
        this.propertyData = propertyData;
    }
}

