/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.simpleinventories.render;

import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.item.Item;
import io.github.pronze.lib.screaminglib.player.PlayerWrapper;
import io.github.pronze.lib.screaminglib.tasker.task.TaskerTask;
import io.github.pronze.lib.simpleinventories.events.SubInventoryOpenEvent;
import io.github.pronze.lib.simpleinventories.inventory.GenericItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.InventoryLink;
import io.github.pronze.lib.simpleinventories.inventory.InventorySet;
import io.github.pronze.lib.simpleinventories.inventory.LocalOptions;
import io.github.pronze.lib.simpleinventories.inventory.PlayerItemInfo;
import io.github.pronze.lib.simpleinventories.inventory.SubInventory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class InventoryRenderer {
    protected final PlayerWrapper player;
    protected SubInventory subInventory;
    protected int page;
    protected final Map<Integer, PlayerItemInfo> itemInfoMap = new HashMap<Integer, PlayerItemInfo>();
    protected final Map<Integer, Item> itemStacksInInventory = new HashMap<Integer, Item>();
    protected final Map<Integer, List<Item>> animations = new HashMap<Integer, List<Item>>();
    protected TaskerTask animator;
    protected int nextAnimationPosition = 0;
    protected boolean mainEventCalled = false;

    public InventoryRenderer(PlayerWrapper player, SubInventory subInventory, int page) {
        this.player = player;
        this.subInventory = subInventory;
        this.page = page;
    }

    public boolean nextPage() {
        if (this.subInventory.getHighestPage() > this.page) {
            ++this.page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean previousPage() {
        if (this.page > 0) {
            --this.page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean jumpToPage(int page) {
        if (this.subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
            this.mainEventCalled = false;
            this.render();
            return true;
        }
        return false;
    }

    public boolean jump(SubInventory subInventory) {
        if (subInventory == null) {
            return false;
        }
        this.subInventory = subInventory;
        this.mainEventCalled = false;
        this.render();
        return true;
    }

    public boolean jump(SubInventory subInventory, int page) {
        if (subInventory == null) {
            return false;
        }
        this.subInventory = subInventory;
        this.mainEventCalled = false;
        this.page = 0;
        if (subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
        }
        this.render();
        return true;
    }

    public boolean jump(InventorySet inventorySet) {
        if (inventorySet == null) {
            return false;
        }
        this.subInventory = inventorySet.getMainSubInventory();
        this.mainEventCalled = false;
        this.render();
        return true;
    }

    public boolean jump(InventorySet inventorySet, int page) {
        if (inventorySet == null) {
            return false;
        }
        this.subInventory = inventorySet.getMainSubInventory();
        this.mainEventCalled = false;
        this.page = 0;
        if (this.subInventory.getHighestPage() > page && page >= 0) {
            this.page = page;
        }
        this.render();
        return true;
    }

    public boolean jump(InventoryLink inventoryLink) {
        if (inventoryLink == null) {
            return false;
        }
        Optional<SubInventory> link = inventoryLink.resolve();
        if (link.isEmpty()) {
            return false;
        }
        return this.jump(link.get());
    }

    public void render() {
        this.clear();
        if (!this.mainEventCalled) {
            SubInventoryOpenEvent openInventoryEvent = new SubInventoryOpenEvent(this.player, this.subInventory, this.page);
            this.subInventory.getInventorySet().getEventManager().fireEvent(openInventoryEvent);
            if (openInventoryEvent.isCancelled()) {
                this.close();
                return;
            }
            this.mainEventCalled = true;
        }
        this.generateNewData();
        this.renderOnPlatform();
    }

    public void close() {
        this.clear();
        this.player.closeInventory();
    }

    protected void clear() {
        if (this.animator != null) {
            this.animator.cancel();
        }
        this.nextAnimationPosition = 0;
        this.itemInfoMap.clear();
        this.itemStacksInInventory.clear();
        this.animations.clear();
    }

    protected Component getTitle() {
        LocalOptions options = this.subInventory.getLocalOptions();
        Component prefix = options.getPrefix();
        if (options.isShowPageNumber()) {
            prefix = prefix.append(Component.text(" - ")).append(Component.text(this.page + 1));
        }
        return prefix;
    }

    protected void generateNewData() {
        int i;
        LocalOptions options = this.subInventory.getLocalOptions();
        int size = options.getRenderActualRows() * options.getItemsOnRow();
        for (i = 0; i < options.getItemsOnRow(); ++i) {
            this.safePutStackToInventory(size, options.getRenderHeaderStart() + i, options.getCosmeticItem().clone());
        }
        for (i = 0; i < options.getItemsOnRow(); ++i) {
            this.safePutStackToInventory(size, options.getRenderFooterStart() + i, options.getCosmeticItem().clone());
        }
        if (!this.subInventory.isMain()) {
            this.safePutStackToInventory(size, options.getRenderHeaderStart(), options.getBackItem().clone());
        }
        if (this.page > 0) {
            this.safePutStackToInventory(size, options.getRenderFooterStart(), options.getPageBackItem().clone());
        }
        if (this.subInventory.getHighestPage() > this.page) {
            this.safePutStackToInventory(size, options.getRenderFooterStart() + options.getItemsOnRow() - 1, options.getPageForwardItem().clone());
        }
        this.subInventory.getContents().stream().filter(this::isOnThisPage).forEach(itemInfo -> {
            PlayerItemInfo playerItemInfo = new PlayerItemInfo(this.player, (GenericItemInfo)itemInfo);
            int pos = itemInfo.getPosition() % options.getItemsOnPage() + options.getRenderOffset();
            if (playerItemInfo.isVisible()) {
                this.safePutStackToInventory(size, pos, playerItemInfo.getStack());
                if (this.subInventory.getInventorySet().isAnimationsEnabled() && playerItemInfo.hasAnimation()) {
                    this.animations.put(pos, List.copyOf(playerItemInfo.getAnimation()));
                }
            }
            this.itemInfoMap.put(pos, playerItemInfo);
        });
    }

    protected void safePutStackToInventory(int max, int position, Item stack) {
        if (position >= 0 && position < max) {
            this.itemStacksInInventory.put(position, stack);
        }
    }

    protected boolean isOnThisPage(GenericItemInfo item) {
        LocalOptions options = this.subInventory.getLocalOptions();
        return item.isWritten() && this.page == item.getPosition() / options.getItemsOnPage();
    }

    protected abstract void renderOnPlatform();

    public abstract boolean isOpened();

    public PlayerWrapper getPlayer() {
        return this.player;
    }

    public SubInventory getSubInventory() {
        return this.subInventory;
    }

    public int getPage() {
        return this.page;
    }

    public Map<Integer, PlayerItemInfo> getItemInfoMap() {
        return this.itemInfoMap;
    }

    public Map<Integer, Item> getItemStacksInInventory() {
        return this.itemStacksInInventory;
    }

    public Map<Integer, List<Item>> getAnimations() {
        return this.animations;
    }

    public TaskerTask getAnimator() {
        return this.animator;
    }

    public int getNextAnimationPosition() {
        return this.nextAnimationPosition;
    }

    public boolean isMainEventCalled() {
        return this.mainEventCalled;
    }
}

