/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba;

import io.github.pronze.lib.pronzelib.scoreboards.ScoreboardManager;
import io.github.pronze.lib.screaminglib.event.EventManager;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.plugin.PluginContainer;
import io.github.pronze.sba.AddonAPI;
import io.github.pronze.sba.config.IConfigurator;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.lang.ILanguageService;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.manager.IArenaManager;
import io.github.pronze.sba.manager.IPartyManager;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.placeholderapi.SBAExpansion;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.service.WrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.MessageUtils;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.lib.sgui.listeners.InventoryListener;

public class SBA
extends PluginContainer
implements AddonAPI {
    private static SBA instance;
    private JavaPlugin cachedPluginInstance;
    private final List<Listener> registeredListeners = new ArrayList<Listener>();

    public static SBA getInstance() {
        return instance;
    }

    public static JavaPlugin getPluginInstance() {
        if (instance == null) {
            throw new UnsupportedOperationException("SBA has not yet been initialized!");
        }
        if (SBA.instance.cachedPluginInstance == null) {
            SBA.instance.cachedPluginInstance = instance.getPluginDescription().as(JavaPlugin.class);
        }
        return SBA.instance.cachedPluginInstance;
    }

    @Override
    public void enable() {
        instance = this;
        this.cachedPluginInstance = instance.getPluginDescription().as(JavaPlugin.class);
        Logger.init(this.cachedPluginInstance);
        ScoreboardManager.init(this.cachedPluginInstance);
    }

    @Override
    public void postEnable() {
        if (Bukkit.getServer().getServicesManager().getRegistration(BedwarsAPI.class) == null) {
            MessageUtils.showErrorMessage("Could not find Screaming-BedWars plugin!, make sure you have the right one installed, and it's enabled properly!");
            return;
        }
        if (Main.getVersionNumber() < 109) {
            MessageUtils.showErrorMessage("Minecraft server is running versions below 1.9.4, please upgrade!");
            return;
        }
        InventoryListener.init((Plugin)this.cachedPluginInstance);
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            Logger.trace("Registering SBAExpansion...", new Object[0]);
            new SBAExpansion().register();
        }
        this.getLogger().info("Plugin has finished loading!");
        this.registerAPI();
        Logger.trace("API has been registered!", new Object[0]);
    }

    public void registerListener(@NotNull Listener listener) {
        if (this.registeredListeners.contains(listener)) {
            return;
        }
        Bukkit.getServer().getPluginManager().registerEvents(listener, (Plugin)SBA.getPluginInstance());
        Logger.trace("Registered listener: {}", listener.getClass().getSimpleName());
    }

    public void unregisterListener(@NotNull Listener listener) {
        if (!this.registeredListeners.contains(listener)) {
            return;
        }
        HandlerList.unregisterAll((Listener)listener);
        this.registeredListeners.remove(listener);
        Logger.trace("Unregistered listener: {}", listener.getClass().getSimpleName());
    }

    public List<Listener> getRegisteredListeners() {
        return List.copyOf(this.registeredListeners);
    }

    private void registerAPI() {
        if (Bukkit.getServer().getServicesManager().getRegistration(AddonAPI.class) == null) {
            Bukkit.getServer().getServicesManager().register(AddonAPI.class, (Object)this, (Plugin)this.cachedPluginInstance, ServicePriority.Normal);
        }
    }

    @Override
    public void disable() {
        EventManager.getDefaultEventManager().unregisterAll();
        EventManager.getDefaultEventManager().destroy();
        Bukkit.getServer().getServicesManager().unregisterAll((Plugin)SBA.getPluginInstance());
    }

    @Override
    public Optional<IGameStorage> getGameStorage(Game game) {
        return ArenaManager.getInstance().getGameStorage(game.getName());
    }

    @Override
    public SBAPlayerWrapper getPlayerWrapper(Player player) {
        return PlayerWrapperService.getInstance().get(player).orElseGet(() -> PlayerMapper.wrapPlayer(player).as(SBAPlayerWrapper.class));
    }

    @Override
    public boolean isDebug() {
        return SBAConfig.getInstance().getBoolean("debug.enabled", false);
    }

    @Override
    public boolean isSnapshot() {
        return this.getVersion().contains("SNAPSHOT") || this.getVersion().contains("dev");
    }

    @Override
    public String getVersion() {
        return this.getPluginDescription().getVersion();
    }

    @Override
    public IArenaManager getArenaManager() {
        return ArenaManager.getInstance();
    }

    @Override
    public IPartyManager getPartyManager() {
        return PartyManager.getInstance();
    }

    @Override
    public WrapperService<Player, SBAPlayerWrapper> getPlayerWrapperService() {
        return PlayerWrapperService.getInstance();
    }

    @Override
    public IConfigurator getConfigurator() {
        return SBAConfig.getInstance();
    }

    @Override
    public boolean isPendingUpgrade() {
        return !this.getVersion().equalsIgnoreCase(SBAConfig.getInstance().node("version").getString());
    }

    @Override
    public ILanguageService getLanguageService() {
        return LanguageService.getInstance();
    }

    @Override
    public JavaPlugin getJavaPlugin() {
        return instance.getPluginDescription().as(JavaPlugin.class);
    }
}

