/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.lib.cloud.annotations.AnnotationParser;
import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandDescription;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.cloud.annotations.specifier.Greedy;
import io.github.pronze.lib.cloud.arguments.parser.ParserParameters;
import io.github.pronze.lib.cloud.arguments.parser.StandardParameters;
import io.github.pronze.lib.cloud.bukkit.CloudBukkitCapabilities;
import io.github.pronze.lib.cloud.execution.CommandExecutionCoordinator;
import io.github.pronze.lib.cloud.meta.CommandMeta;
import io.github.pronze.lib.cloud.minecraft.extras.MinecraftHelp;
import io.github.pronze.lib.cloud.paper.PaperCommandManager;
import io.github.pronze.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import io.github.pronze.lib.screaminglib.plugin.ServiceManager;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnEnable;
import io.github.pronze.sba.commands.GamesInvNPCCommand;
import io.github.pronze.sba.commands.SBACommand;
import io.github.pronze.sba.commands.ShoutCommand;
import io.github.pronze.sba.commands.party.PartyCommand;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import java.util.function.Function;
import lombok.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

@Service(initAnother={SBACommand.class, GamesInvNPCCommand.class, ShoutCommand.class, PartyCommand.class})
public class CommandManager {
    private PaperCommandManager<CommandSender> manager;
    private AnnotationParser<CommandSender> annotationParser;
    private MinecraftHelp<CommandSender> minecraftHelp;

    public static CommandManager getInstance() {
        return ServiceManager.get(CommandManager.class);
    }

    @OnEnable
    public void onEnable(JavaPlugin plugin) {
        if (this.manager != null) {
            return;
        }
        Function executionCoordinatorFunction = CommandExecutionCoordinator.simpleCoordinator();
        Function mapperFunction = Function.identity();
        try {
            this.manager = new PaperCommandManager((Plugin)plugin, executionCoordinatorFunction, mapperFunction, mapperFunction);
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("Failed to initialize the command manager");
            SBAUtil.disablePlugin(plugin);
            return;
        }
        BukkitAudiences bukkitAudiences = BukkitAudiences.create((Plugin)plugin);
        this.minecraftHelp = new MinecraftHelp<CommandSender>("/sba help", bukkitAudiences::sender, this.manager);
        if (this.manager.queryCapability(CloudBukkitCapabilities.BRIGADIER)) {
            try {
                this.manager.registerBrigadier();
            }
            catch (Exception e) {
                Logger.error("Could not register Brigadier\r{}", e);
            }
        }
        if (this.manager.queryCapability(CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            this.manager.registerAsynchronousCompletions();
        }
        Function<ParserParameters, CommandMeta> commandMetaFunction = p -> CommandMeta.simple().with(CommandMeta.DESCRIPTION, p.get(StandardParameters.DESCRIPTION, "No description")).build();
        this.annotationParser = new AnnotationParser<CommandSender>(this.manager, CommandSender.class, commandMetaFunction);
        this.annotationParser.parse(this);
    }

    @CommandMethod(value="sba help [query]")
    @CommandDescription(value="Help menu")
    private void commandHelp(@NonNull CommandSender sender, @Argument(value="query") @Greedy String query) {
        if (sender == null) {
            throw new NullPointerException("sender is marked non-null but is null");
        }
        sender.sendMessage("commandHelp");
        this.minecraftHelp.queryCommands(query == null ? "" : query, sender);
    }

    public PaperCommandManager<CommandSender> getManager() {
        return this.manager;
    }

    public AnnotationParser<CommandSender> getAnnotationParser() {
        return this.annotationParser;
    }

    public MinecraftHelp<CommandSender> getMinecraftHelp() {
        return this.minecraftHelp;
    }
}

