/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.cloud.annotations.CommandPermission;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.game.GameMode;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.GamesInventoryService;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Service
public class GamesInvNPCCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="sba gamesinv spawnnpc <mode>")
    @CommandPermission(value="sba.spawnnpc")
    private void commandSpawn(@NotNull Player player, @Argument(value="mode") @NotNull GameMode mode) {
        GamesInventoryService.getInstance().addNPC(mode, player.getLocation());
        GamesInventoryService.getInstance().addViewer(PlayerMapper.wrapPlayer(player));
        LanguageService.getInstance().get(MessageKeys.ADDED_NPC).send(PlayerMapper.wrapPlayer(player));
    }

    @CommandMethod(value="sba gamesinv removenpc")
    @CommandPermission(value="sba.removenpc")
    private void commandRemove(@NotNull Player player) {
        LanguageService.getInstance().get(MessageKeys.REMOVABLE_NPC_TOGGLE).send(PlayerMapper.wrapPlayer(player));
        GamesInventoryService.getInstance().addEditable(PlayerMapper.wrapPlayer(player), GamesInventoryService.Action.Remove, null);
    }

    @CommandMethod(value="sba gamesinv editnpc <skin>")
    @CommandPermission(value="sba.editnpc")
    private void commandEdit(@NotNull Player player, @Argument(value="skin") @NotNull String skin) {
        LanguageService.getInstance().get(MessageKeys.SKIN_NPC_TOGGLE).send(PlayerMapper.wrapPlayer(player));
        GamesInventoryService.getInstance().addEditable(PlayerMapper.wrapPlayer(player), GamesInventoryService.Action.Skin, skin);
    }
}

