/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.lib.cloud.annotations.Argument;
import io.github.pronze.lib.cloud.annotations.CommandDescription;
import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.cloud.annotations.CommandPermission;
import io.github.pronze.lib.configurate.CommentedConfigurationNode;
import io.github.pronze.lib.configurate.ConfigurationNode;
import io.github.pronze.lib.configurate.serialize.SerializationException;
import io.github.pronze.lib.configurate.yaml.YamlConfigurationLoader;
import io.github.pronze.lib.kyori.adventure.text.Component;
import io.github.pronze.lib.screaminglib.player.PlayerMapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.inventories.GamesInventory;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.utils.SBAUtil;
import io.github.pronze.sba.utils.ShopUtil;
import io.leangen.geantyref.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;

@Service
public class SBACommand {
    private boolean gamesInvEnabled;
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        this.gamesInvEnabled = SBAConfig.getInstance().getBoolean("games-inventory.enabled", true);
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("gameMode", (commandSenderCommandContext, s) -> List.of("solo", "double", "triple", "squad"));
        CommandManager.getInstance().getManager().getParserRegistry().registerSuggestionProvider("maps", (ctx, s) -> Main.getGameNames());
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="sba reload")
    @CommandDescription(value="reload command")
    @CommandPermission(value="sba.reload")
    private void commandReload(@NotNull CommandSender sender) {
        SBAUtil.reloadPlugin(SBA.getPluginInstance());
    }

    @CommandMethod(value="sba setlobby")
    @CommandDescription(value="set lobby command")
    @CommandPermission(value="sba.setlobby")
    private void commandSetLobby(@NotNull Player player) {
        Location location = player.getLocation();
        try {
            ConfigurationNode lobbyNode = SBAConfig.getInstance().node("main-lobby");
            lobbyNode.node("enabled").set(true);
            lobbyNode.node("world").set(location.getWorld().getName());
            lobbyNode.node("x").set(location.getX());
            lobbyNode.node("y").set(location.getY());
            lobbyNode.node("z").set(location.getZ());
            lobbyNode.node("yaw").set(Float.valueOf(location.getYaw()));
            lobbyNode.node("pitch").set(Float.valueOf(location.getPitch()));
            SBAConfig.getInstance().saveConfig();
            LanguageService.getInstance().get(MessageKeys.SUCCESSFULLY_SET_LOBBY).send(PlayerMapper.wrapPlayer(player));
            SBAUtil.reloadPlugin(SBA.getPluginInstance());
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
        }
    }

    @CommandMethod(value="sba resetconfig")
    @CommandDescription(value="reset sba configuration")
    @CommandPermission(value="sba.reset")
    private void commandReset(@NotNull CommandSender sender) {
        Component component = LanguageService.getInstance().get(MessageKeys.COMMAND_RESETTING).toComponent();
        PlayerMapper.wrapSender(sender).sendMessage(component);
        SBAConfig.getInstance().upgrade();
        Component c2 = LanguageService.getInstance().get(MessageKeys.RESET_COMMAND_SUCCESS).toComponent();
        PlayerMapper.wrapSender(sender).sendMessage(c2);
    }

    @CommandMethod(value="sba generate <gamemode> <maps>")
    @CommandDescription(value="generate games inventory configuration files")
    @CommandPermission(value="sba.generate")
    private void commandGenerate(@NotNull CommandSender sender, @Argument(value="gamemode", suggestions="gameMode") @NotNull String gameMode, @Argument(value="maps", suggestions="maps") @NotNull String[] mapsArg) {
        final String stringedGameMode = SBAUtil.capitalizeFirstLetter(gameMode);
        final List<String> maps = List.of(mapsArg);
        if (maps.isEmpty()) {
            return;
        }
        Logger.trace("Generating Games Inventory file for game mode: {}", gameMode);
        File file = new File(SBA.getPluginInstance().getDataFolder(), "games-inventory/" + gameMode + ".yml");
        if (file.exists()) {
            Logger.trace("Deleting pre existing games inventory file, status: {}", file.delete());
        }
        try {
            Logger.trace("Creating new games inventory file, status: {}", file.createNewFile());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        ConfigurationNode node = SBAConfig.getInstance().node("lobby-scoreboard", "player-size", "games");
        maps.forEach(arg -> {
            try {
                node.node(arg).set(Integer.class, Integer.valueOf(ShopUtil.getIntFromMode(gameMode)));
                SBAConfig.getInstance().saveConfig();
                SBAConfig.getInstance().forceReload();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(file.getAbsoluteFile().toPath())).build();
        try {
            CommentedConfigurationNode root = (CommentedConfigurationNode)loader.load();
            ((CommentedConfigurationNode)root.node(new Object[]{"data"})).setList(new TypeToken<Map<String, String>>(){}, (List)List.of(Map.of("stack", "RED_BED;1;\u00a7aBed Wars \u00a77(%s);\u00a77Play Bed Wars {\u00a77%s}; ;\u00a7eClick to play!".replaceAll(Pattern.quote("%s"), stringedGameMode), "row", "1", "column", "3", "properties", "randomly_join"), Map.of("stack", "BARRIER;1;\u00a7cExit", "row", "3", "column", "4", "properties", "exit"), Map.of("stack", "ENDER_PEARL;1;\u00a7cClick here to rejoin!;\u00a77Click here to rejoin the lastly joined game.", "properties", "rejoin", "row", "3", "column", "8")));
            ((CommentedConfigurationNode)((CommentedConfigurationNode)root.node(new Object[]{"data"})).appendListNode()).set(Map.of("stack", "OAK_SIGN;1;\u00a7aMap Selector \u00a77(%s);\u00a77Pick which map you want to play;\u00a77from a list of available servers.; ;\u00a7eClick to browse!".replaceAll(Pattern.quote("%s"), stringedGameMode), "row", "1", "column", "5", "options", Map.of("rows", "6", "render_actual_rows", "6"), "items", new ArrayList<Map<String, Object>>(){
                {
                    AtomicInteger col = new AtomicInteger(1);
                    AtomicInteger row = new AtomicInteger(1);
                    maps.stream().map(mapName -> Main.getInstance().getGameByName(mapName)).forEach((? super T game) -> {
                        col.set(col.get() + 1);
                        if (col.get() >= 6) {
                            row.set(row.get() + 1);
                            col.set(2);
                        }
                        if (row.get() >= 3) {
                            return;
                        }
                        this.add(Map.of("stack", "PAPER;1;\u00a7a" + game.getName() + ";\u00a77" + stringedGameMode + "; ;\u00a7aClick to play", "row", String.valueOf(row.get()), "column", String.valueOf(col.get()), "properties", Map.of("name", "join", "gameName", game.getName())));
                    });
                    this.add(Map.of("stack", "ARROW;1;\u00a7cGo Back", "row", 4, "column", 4, "locate", "main"));
                }
            }));
            loader.save(root);
            Component generated = LanguageService.getInstance().get(MessageKeys.GAMESINV_GENERATED).toComponent();
            PlayerMapper.wrapSender(sender).sendMessage(generated);
            SBAUtil.reloadPlugin(SBA.getPluginInstance());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    @CommandMethod(value="sba gamesinv <gamemode>")
    @CommandDescription(value="open GamesInventory for player")
    private void commandGamesInv(@NotNull Player player, @Argument(value="gamemode", suggestions="gameMode") @NotNull String gameMode) {
        if (!this.gamesInvEnabled) {
            Component disabled = LanguageService.getInstance().get(MessageKeys.GAMES_INV_DISABLED).toComponent();
            PlayerMapper.wrapPlayer(player).sendMessage(disabled);
            return;
        }
        int mode = ShopUtil.getIntFromMode(gameMode);
        GamesInventory.getInstance().openForPlayer(player, mode);
    }

    @CommandMethod(value="sba upgrade")
    @CommandPermission(value="sba.upgrade")
    @CommandDescription(value="upgrade config files")
    private void commandUpgrade(@NotNull CommandSender sender) {
        if (!SBA.getInstance().isPendingUpgrade()) {
            String cannotExecute = LanguageService.getInstance().get(MessageKeys.COMMAND_CANNOT_EXECUTE).toString();
            PlayerMapper.wrapSender(sender).sendMessage(cannotExecute);
            return;
        }
        SBAConfig.getInstance().upgrade();
        LanguageService.getInstance().load(SBA.getPluginInstance());
        String upgraded = LanguageService.getInstance().get(MessageKeys.COMMAND_SUCCESSFULLY_UPGRADED).toString();
        PlayerMapper.wrapSender(sender).sendMessage(upgraded);
    }

    @CommandMethod(value="sba cancel")
    @CommandDescription(value="cancel configuration upgrades")
    @CommandPermission(value="sba.cancel")
    private void commandCancel(@NotNull CommandSender sender) {
        if (!SBA.getInstance().isPendingUpgrade()) {
            String m1 = LanguageService.getInstance().get(MessageKeys.CANNOT_DO_COMMAND).toString();
            PlayerMapper.wrapSender(sender).sendMessage(m1);
            return;
        }
        try {
            SBAConfig.getInstance().node("version").set(SBA.getInstance().getVersion());
            SBAConfig.getInstance().saveConfig();
            String m2 = LanguageService.getInstance().get(MessageKeys.COMMAND_CANCEL_UPGRADE).toString();
            PlayerMapper.wrapSender(sender).sendMessage(m2);
        }
        catch (SerializationException ex) {
            ex.printStackTrace();
        }
    }
}

