/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyInviteAcceptEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyAcceptCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p accept")
    private void commandAccept(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        Optional<IParty> optionalParty = PartyManager.getInstance().getInvitedPartyOf(player);
        optionalParty.ifPresentOrElse(party -> {
            SBAPlayerPartyInviteAcceptEvent acceptEvent = new SBAPlayerPartyInviteAcceptEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)acceptEvent);
            if (acceptEvent.isCancelled()) {
                return;
            }
            player.getSettings().disable(PlayerSetting.INVITED_TO_PARTY).enable(PlayerSetting.IN_PARTY);
            party.addPlayer(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCEPTED).replace("%player%", player.getName()).send((CommandSenderWrapper[])party.getMembers().toArray(SBAPlayerWrapper[]::new));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_INVITED).send(player));
    }
}

