/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.lib.cloud.annotations.CommandMethod;
import io.github.pronze.lib.screaminglib.sender.CommandSenderWrapper;
import io.github.pronze.lib.screaminglib.utils.annotations.Service;
import io.github.pronze.lib.screaminglib.utils.annotations.methods.OnPostEnable;
import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.events.SBAPlayerPartyDisbandEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

@Service
public class PartyDisbandCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="party|p disband")
    private void commandDisband(@NotNull Player playerArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        if (!player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_IN_PARTY).send(player);
            return;
        }
        PartyManager.getInstance().getPartyOf(player).ifPresentOrElse(party -> {
            if (!party.getPartyLeader().equals(player)) {
                LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCESS_DENIED).send(player);
                return;
            }
            SBAPlayerPartyDisbandEvent disbandEvent = new SBAPlayerPartyDisbandEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)disbandEvent);
            if (disbandEvent.isCancelled()) {
                return;
            }
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_DISBAND).send((CommandSenderWrapper[])party.getMembers().toArray(SBAPlayerWrapper[]::new));
            SBA.getInstance().getPartyManager().disband(party.getUUID());
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ERROR).send(player));
    }
}

